import json
import threading
from concurrent.futures.thread import ThreadPoolExecutor
import pandas as pd
from core.config.env import env, red
from libs.db_link import LinkMysql


class HomePageDisplay(object):
    def __init__(self, date, unique_tag, amount_type, reference_type, type):
        self.date = 'assets_log_' + date
        self.unique_tag = unique_tag
        self.amount_type = amount_type
        self.reference_type = reference_type
        self.type = type
        self.account = []
        self.guild = []
        self.total_money = 0

    def mysql_query_data(self, assets_cond, page, size):
        assets_sql = f"select amount from {self.date} where {' and '.join(assets_cond)} limit {page},{size}"
        total_data = LinkMysql(env.DB_HISTORY).perform_mysql(assets_sql)
        df = pd.DataFrame(total_data)
        total = df['amount'].sum()
        self.total_money = self.total_money + total

    def get_month_data(self):

        acc_sql = "select unique_tag,uuid from fi_account"
        guild_sql = "select uuid from guild"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, acc_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, guild_sql)
        acc_data = future1.result()
        guild_data = future2.result()
        account = [i['uuid'] for i in acc_data]
        guild = [i['uuid'] for i in guild_data]
        assets_cond = []
        assets_cond.append(f" reference_type='{self.reference_type}'")
        if self.unique_tag == 'guild_account':
            assets_cond.append(f" uuid in{tuple(guild)}")
        elif self.unique_tag == 'user_account':
            if self.amount_type == 0:
                amount_type = 'consumablel'
            else:
                amount_type = 'withdrawable'
            assets_cond.append(f" uuid not in{tuple(guild + account)} and amount_type='{amount_type}'")
        elif self.unique_tag == 'knapsack_account':
            assets_cond.append(f" amount_type='backpack'")
        else:
            acc_uuid = [i['uuid'] for i in acc_data if i['unique_tag'] == self.unique_tag]
            if not acc_uuid:
                print('没找到系统账户')
                return []
            assets_cond.append(f" uuid='{acc_uuid[0]}'")
        assets_sql = f"select amount from {self.date} where {' and '.join(assets_cond)}"
        total_data = LinkMysql(env.DB_HISTORY).query_mysql(assets_sql)
        df = pd.DataFrame(total_data)
        df_total = df.sum()
        total_dict = df_total.to_dict()
        if total_data:
            return total_dict.get('amount')/1000
        return 0
