from typing import Optional

from fastapi import APIRouter, Depends

from app.api.home.crud import HomePageDisplay
from libs.result_format import HttpResultResponse, HttpMessage
from libs.token_verify import login_required

router = APIRouter()


@router.get("/multidimensional/total")
def read_account(date: Optional[str] = "",
                 unique_tag: Optional[str] = "",
                 account_type: Optional[str] = "",
                 amount_type: Optional[str] = "",
                 reference_type: Optional[str] = "",
                 type: Optional[int] = None, token=Depends(login_required)):
    """月，业务类型,消费类型，出入账目统计"""
    if not all([date, reference_type]) or type is None or (not unique_tag and not account_type):
        return HttpResultResponse(code=500, msg=HttpMessage.MISSING_PARAMETER)
    if account_type and not unique_tag:
        unique_tag = account_type
    total = HomePageDisplay(date, unique_tag, amount_type, reference_type, type).get_month_data()
    return HttpResultResponse(data=total)
