from sqlalchemy import Column, Integer, String, Text, DateTime, Float
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class GuildMargin(Base, SerializerMixin):
    """公会保证金表"""
    __tablename__ = "guild_margin"

    id = Column(Integer, primary_key=True, index=True)
    guild_id = Column(Integer, index=True, comment="公会id")
    guild_name = Column(String(100), comment="公会名字")
    amount = Column(Float, comment="操作金额")
    type = Column(Integer, default=1, comment="1:缴纳保证金 -1:扣减保证金")
    remark = Column(String(255), comment="扣减理由")
    violate_images = Column(String(255), comment="违规图片地址")
    deduction_images = Column(String(255), comment="扣减图片地址")
    status = Column(Integer, comment="3表示未处理 4表示成功 5表示拒绝")
    create_time = Column(DateTime, comment="添加时间")

    __table_args__ = {'comment': '公会保证金记录'}
