from app import get_db

from sqlalchemy.orm import Session
from app.api.statement import crud, schemas
from fastapi import Depends, APIRouter, Request
from libs.result_format import HttpResultResponse

router = APIRouter()


@router.post("/recharge/list")
def statement_recharge_list(data: schemas.StatementList):
    """充值报表列表"""
    statement_list = crud.get_statements(data)
    return HttpResultResponse(data=statement_list)


@router.post("/create")
def create_user(data: schemas.StatementCreate, db: Session = Depends(get_db)):
    """添加"""

    res = crud.create_statementr(db=db, user=data)
    return HttpResultResponse(data=res.id)




