from typing import Optional

from pydantic import BaseModel


class StatementBase(BaseModel):
    user_id: int
    zb_number: int
    order_number: int


class StatementCreate(StatementBase):

    nickname: str
    recharge_amount: float
    recharge_channel: str
    flowing_water_number: int


class StatementList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    start_time:  Optional[str] = ""
    end_time: Optional[str] = ""
    order_number: Optional[str] = ""
    user_id: Optional[int] = None
    flowing_water_number: Optional[str] = ""
    recharge_channel: Optional[str] = ""


class Statement(StatementBase):
    id: int

    class Config:
        orm_mode = True
