from typing import Optional
from sqlalchemy.orm import Session

from core.config.env import env
from libs.db_link import LinkMysql
from models import statement as models
from app.api.statement import schemas
from sqlalchemy import and_


def get_statement(db: Session, user_id: int):
    return db.query(models.Statement).filter(models.Statement.id == user_id)


def get_statement_by_name(db: Session, username: str):
    return db.query(models.Statement).filter(models.Statement.username == username).first()


def get_statements(param):
    page = param.page if param.page else 1
    size = param.size if param.size else 10
    sql = f"select order_number,userid,user_number,nick_name,money,paychannel,sid,lastupdate,current,payment_time " \
          f"from orders o INNER JOIN v2_user v on o.userid = v.user_id where o.order_number LIKE '%{param.get('order_number')}%' and " \
          f"o.userid LIKE '%{param.get('user_id')}%' and o.sid LIKE '%{param.get('sid')}%' and o.paychannel LIKE '%{param.get('paychannel')}%' and orcurrent>='{param.get('start_time')}' and current <= '{param.get('end_time')}' LIMIT {(int(page)-1) * size},{page * size}"

    query_res = LinkMysql(env.MysqlDB).query_mysql(sql)
    return query_res
