import time
import logging
import os
import socket

from core.config.env import env

hostname = socket.gethostname()
current_directory = os.path.dirname(os.path.abspath(__file__))


def get_current_time():
    from datetime import datetime, timedelta, timezone
    utc_dt = datetime.utcnow().replace(tzinfo=timezone.utc)
    current_time = utc_dt.astimezone(timezone(timedelta(hours=8))).strftime('%Y-%m-%d')  # 返回当前时间
    return current_time


class Logger(object):
    level_relations = {
        'debug': logging.DEBUG,
        'info': logging.INFO,
        'warning': logging.WARNING,
        'error': logging.ERROR,
        'crit': logging.CRITICAL
    }
    count = 0

    def __init__(self, log_level=20):
        fmt = "[%(asctime)s] [%(process)d] [%(levelname)s] - %(module)s.%(funcName)s (%(filename)s:%(lineno)d) - %(message)s"
        self.current_time = get_current_time()
        filename = env.LOG_PATH + 'operation' + "-" + get_current_time() + '.log'
        self.logger = logging.getLogger(filename)
        self.format_str = logging.Formatter(fmt)  # 设置日志格式
        self.create_handler(log_level)
        # Logger.count += 1

    def create_handler(self, log_level):
        self.current_time = get_current_time()
        if log_level == 40:
            filename = env.LOG_ERROR_PATH + get_current_time() + '.log'
        else:
            filename = env.LOG_PATH + get_current_time() + '.log'
        self.logger = logging.getLogger(filename)
        self.logger.setLevel(logging.INFO)  # 设置日志级别
        if not self.logger.handlers:
            sh = logging.StreamHandler()
            sh.setFormatter(self.format_str)
            th = logging.FileHandler(filename=filename, encoding='utf-8')
            th.setFormatter(self.format_str)  # 设置文件里写入的格式
            self.logger.addHandler(sh)  # 把对象加到logger里
            self.logger.addHandler(th)

    def info(self, msg):
        current_time = get_current_time()
        if self.current_time != current_time:
            self.create_handler()
        self.logger.info(msg)
        return

    def warning(self, msg):
        current_time = get_current_time()
        if self.current_time != current_time:
            self.create_handler()
        self.logger.warning(msg)
        return

    def error(self, msg):
        current_time = get_current_time()
        if self.current_time != current_time:
            self.create_handler()
        self.logger.error(msg)
        return
