import decimal
import json
from datetime import datetime

from fastapi import status
from fastapi.responses import Response


class HttpMessage(object):
    SUCCESS = "操作成功"
    USER_EXIST = "用户已存在"
    USER_NOT_EXIST = "用户不存在"
    LOGIN_SUCCESS = "登录成功"

    ROLE_EXIST = "角色已存在"
    NO_DELETE_ROLE = "不能删除已绑定用户的角色！"

    ACCOUNT_EXIST = "账号已存在"
    TYPE_EXIST = "类目标识已存在"

    DELETE_LOSE = '删除失败'
    LOSE = '操作失败'


class DecimalEncoder(json.JSONEncoder):
    def default(self, res):
        if isinstance(res, decimal.Decimal):
            return float(res)
        if isinstance(res, datetime):
            print(res.strftime("%Y-%m-%d %H:%M:%S"))
            return res.strftime("%Y-%m-%d %H:%M:%S")
        super(DecimalEncoder, self).default(res)


class HttpResultResponse(Response):
    def __init__(self, code=None, msg=None,**kwargs):
        result_dict = {
            'code': code if code else status.HTTP_200_OK,
            'msg': msg if msg else HttpMessage.SUCCESS,
        }
        result_dict = {**result_dict, **kwargs}
        print(result_dict)
        super().__init__(
            content=json.dumps(result_dict, cls=DecimalEncoder),
            media_type="application/json",
            status_code=result_dict.get('code')
        )
