import time
from datetime import timedelta, datetime

import uvicorn
from fastapi import FastAPI, Depends
from jose import jwt

from app.api.api_v1 import api_router
from starlette.middleware.cors import CORSMiddleware
from fastapi import Request

from core.config.env import env
from core.dependencies.auth_dependen import create_access_token
from libs.functions import time_format
from libs.token_verify import oauth2_scheme

app = FastAPI()

origins = ['*']  # 可以设置为'*'，即为所有。
# 设置跨域传参
app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,  # 设置允许的origins来源
    allow_credentials=True,
    allow_methods=['*'],  # 设置允许跨域的http方法，比如 get、post、put等。
    allow_headers=['*'])  # 允许跨域的headers，可以用来鉴别来源等作用。

@app.middleware("http")
async def add_process_time_header(request: Request, call_next):
    hs = request.headers
    token=hs.get("authorization").replace('Bearer','').replace(' ','')
    start_time = time.time()
    response = await call_next(request)
    process_time = time.time() - start_time
    response.headers["X-Process-Time"] = str(process_time)
    if token:
        payload = jwt.decode(token, env.SECRET_KEY, algorithms=[env.ALGORITHM])
        timestamp=payload.get("exp")
        access_token_expires = timedelta(hours=time_format(timestamp))
        create_access_token({'username':payload.get("xup"),'password':payload.get("password")},expires_delta=access_token_expires)  #更新token时间
    return response

app.include_router(api_router, prefix="/api")  # 路由


if __name__ == '__main__':
    uvicorn.run(app=app, host="0.0.0.0", port=8009)
