from fastapi import Depends, APIRouter
from sqlalchemy.orm import Session
from app import get_db
from app.api.margin import schemas, crud
from libs.result_format import HttpResultResponse

router = APIRouter()


@router.post("/list")
def guild_margin_list(data: schemas.GuildMarginList, db: Session = Depends(get_db)):
    """保证金列表"""
    result, total = crud.get_margin(db, data.dict(exclude_none=True))
    return HttpResultResponse(total=total, data=result)


@router.post("/examine")
def margin_examine(data: schemas.MarginExamine, db: Session = Depends(get_db)):
    """保证金确认，拒绝"""
    result = crud.margin_dispose(db, data.dict(exclude_none=True))
    return HttpResultResponse(msg=result)
