from sqlalchemy import Column, Integer, String, DateTime, Float
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class User(Base, SerializerMixin):
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, index=True)
    username = Column(String(100), unique=True, index=True, comment="用户名")
    remark = Column(String(255), comment="描述")
    unique = Column(String(50), unique=True, comment="唯一标识")
    hashed_password = Column(String(50), comment="密码")
    config_key = Column(String(50))
    uuid = Column(String(50))
    role_id = Column(Integer, comment="角色id")
    google_key = Column(String(255), comment="谷歌动态码secret标识")
    remaining_sum = Column(Float, comment="账户余额")
    entry_account = Column(String(255), comment="入账类目")
    out_account = Column(String(255), comment="出账类目")
    create_time = Column(DateTime, comment="创建时间")
    update_time = Column(DateTime, comment="修改时间")

    __table_args__ = {'comment': '系统用户表'}


class Authority(Base):
    __tablename__ = "authority"

    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(50), index=True, comment="权限名称")
    up_one_level = Column(Integer, index=True, comment="上级权限id")
    create_time = Column(DateTime, comment="创建时间")

    __table_args__ = {'comment': '菜单权限表'}


class V2User(Base, SerializerMixin):
    __tablename__ = "v2_user"

    user_id = Column(Integer, primary_key=True, index=True)
    nick_name = Column(String(255), comment="昵称")
    user_number = Column(Integer, comment="用户靓号")
    mobile = Column(String(45), comment="用户手机号")
    user_name = Column(String(30), comment="帐号")
    password = Column(String(32), comment="密码")
    register_time = Column(Integer, comment="注册时间")
    last_login_time = Column(Integer, default=0, comment="最后登录时间[时间戳]")
    last_login_device = Column(String(64), default='', comment="最后登录设备")
    last_login_ip = Column(Integer, default=0, comment="最后登录ip[长整形]")
    heade_portrait = Column(String(255), default='', comment="头像[不存oss前缀]")
    is_no_play = Column(Integer, default=0, comment="是否禁播(0可以播,1禁播)")
    is_achor = Column(Integer, default=0, comment="是否是主播，0不是，1是线上，2是线下,3未知")
    parent_id = Column(Integer, default=0, comment="上级用户ID(分享者父ID)")
    user_status = Column(Integer, default=0, comment="用户注销状态:-2注销 -1：禁用 0正常")
    anchor_level = Column(Integer, default=1, comment="主播等级")
    user_level = Column(Integer, default=1, comment="活跃值等级(原用户等级)")
    wealth_level = Column(Integer, default=0, comment="财富等级")
    is_pk = Column(Integer, default=0, comment="是否在pk中")
    is_showing = Column(Integer, default=0, comment="主播是否正在直播(1在直播,0不在直播)")
    third_user_id = Column(String(50), default=0, comment="第三方用户id")
    user_type = Column(Integer, default=0, comment="用户类型(0:普通用户,9:机器人,6:客服,8:运营,7:代理,11水军[在分销商统计，主播统计中会排除这些人的统计])")
    mac = Column(String(255), default='', comment="设备的mac")
    channel_name = Column(String(100), default='', comment="渠道")
    version = Column(String(50), default='', comment="注册版本号")
    show_title = Column(String(100), default='', comment="开播标题")
    upload_cover = Column(String(255), default='', comment="主播封面[去除OSS前缀]")
    agent_addtime = Column(Integer, default=0, comment="添加代理时间")
    withdraw_state = Column(Integer, default=0, comment="禁止提现状态0可以1不可以")
    show_background = Column(String(200), comment="直播间背景图")
    uuid = Column(String(100), default=0, comment="UUID")
    reg_source = Column(String(100), comment="冗余包名")
    show_wish_status = Column(Integer, default=0, comment="冗余包名")
    wish_status = Column(Integer, default=0, comment="直播间心愿任务状态（0：关闭，1：开启）")
    titleid = Column(Integer, comment="称号id")
    update_time = Column(DateTime, comment="修改时间")
    task_level = Column(Integer, default=0, comment="任务等级")

    __table_args__ = {'comment': '用户基础表'}
