from typing import Optional

from fastapi import HTTPException
from pydantic import BaseModel, validator


class PublicModel(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    start_time: Optional[str] = ""
    end_time: Optional[str] = ""


class AccountCreate(BaseModel):
    name: str
    remark: Optional[str] = None
    unique_tag: str
    config_key: Optional[str] = None
    income: Optional[list] = []
    output: Optional[list] = []


class AccountList(BaseModel):
    name: Optional[str] = None
    page: Optional[int] = None
    size: Optional[int] = None


class AccountUpdate(BaseModel):
    id: int
    name: str
    remark: str
    income: list
    output: list


class FinanceInfo(PublicModel):
    unique_tag: str
    id: Optional[int] = None


class FinanceDetails(PublicModel):
    type: Optional[int] = None
    gift_type: Optional[str] = ""
    uuid: str
    user_id: Optional[int] = None
    unique_tag: Optional[str] = ""


class FixTable(BaseModel):
    type: int
    uuid: str
    money: float
    amount_type: Optional[str] = "consumable"
    remark: str

    @validator('money')
    def money_must_contain_space(cls, c):
        if c:
            c = round(float(c), 3)
        return c


class AccountTypeUpdate(BaseModel):
    id: int = None
    key_name: str = ""
    key_value: str = ""
    type: int = None


class AccountTypeList(AccountTypeUpdate):
    page: int = None
    size: int = None


class CreateType(BaseModel):
    id: Optional[int] = None
    keyName: Optional[str] = None
    keyValue: Optional[str] = None
    type: Optional[int] = None


class Recovery_fix(PublicModel):
    uuid: Optional[str] = None


class RecoveryTable(BaseModel):
    uuid: Optional[str] = ''
    type: int
    out_money: Optional[int] = None
    entry_money: Optional[int] = None
    from_time: Optional[str] = ''
    cont: Optional[str] = ''

    @validator('cont')
    def cont_must_contain_space(cls, c):
        if len(c) > 200:
            raise HTTPException(status_code=500, detail="备注太长，限制200个字符")
        return c


class RecoveryupdateTable(RecoveryTable):
    id: int
