import threading
import time
from concurrent.futures.thread import ThreadPoolExecutor
from datetime import datetime
import pandas as pd
from sqlalchemy import and_, func
from sqlalchemy.orm import Session
from app.api.account import schemas
from core.config.env import env
from libs.business import TYPE_NAME
from libs.db_link import LinkMysql
from libs.functions import wrapper_out, get_now_timestamp, uuid, get_before_timestamp, time_str_to_timestamp, \
    get_yesterday_timestamp, search
from libs.orm import QueryAllData
from models import account as models
from models.account import AccountFinance, AccountFinanceDetails, AccountType

locka = threading.Lock()


def get_account(name):
    """查询单个账户"""
    sql = f"select id from fi_account where name='{name}'"
    return LinkMysql(env.DB_3YV2).query_mysql(sql)


def get_id_to_authority(db: Session, role_id: int):
    return db.query(models.Account).filter(models.Account.id == role_id).first()


class HDUd():
    def __init__(self):
        self.result_list = []

    def thead_task(self, i):
        if i.get("income"):
            income_list = i.get('income').split(',')
            i['income'] = [int(i) for i in income_list]
        else:
            i['income'] = []
        if i.get("output"):
            output_list = i.get('output').split(',')
            i['output'] = [int(i) for i in output_list]
        else:
            i['output'] = []
        i["remark"] = i.get("description")
        if i['unique_tag']:
            start, end = get_yesterday_timestamp()
            if i['unique_tag'] == 'guild_account':
                sql = f"select sum(initial_money) as number from v3_guild_account_statistics where create_time>={start} and create_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'anchor_account':
                sql = f"select sum(initial_money) as number from v3_user_account_statistics where date>={start} and date<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'user_account':
                sql = f"select sum(initial_money) as number from finance_data_calculation_sum where type=1 and calculation_time>={start} and calculation_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'knapsack_account':
                sql = f"select sum(initial_money) as number from finance_data_calculation_sum where type=4 and calculation_time>={start} and calculation_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'pledgeDeduction':
                sql = f"select sum(initial_money) as number from finance_data_calculation_sum where type=5 and calculation_time>={start} and calculation_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            else:
                platform_data = search({"uuid": i['uuid']}, 'Server.UserQuery.GetUserAsset')
                if platform_data['status']:
                    try:
                        i['consumable'] = platform_data['data']['result']['data']['asset_balance']['consumable']['current_amount']
                    except Exception as e:
                        print(e)
                        i['consumable'] = 0
        else:
            i['consumable'] = 0
        self.result_list.append(i)

    def get_account_list(self, name, page, size):
        """账户列表，查询"""
        if name:
            count_sql = f"select count(id) as num from fi_account where name like '%{name}%'"
            number = LinkMysql(env.DB_3YV2).query_mysql(count_sql)
            if number:
                count = number[0].get("num")
            else:
                count = 0
            data_sql = f"select id,name,unique_tag,uuid,config_key,beneficiary,description,create_time, income, output from fi_account where name like '%{name}%' ORDER BY id DESC LIMIT {(int(page) - 1) * size},{size}"
            query_res = LinkMysql(env.DB_3YV2).query_mysql(data_sql)
        else:
            count_sql = f"select count(id) as num from fi_account"
            number = LinkMysql(env.DB_3YV2).query_mysql(count_sql)
            if number:
                count = number[0].get("num")
            else:
                count = 0
            data_sql = f"select id,name,unique_tag,uuid,config_key,beneficiary,description,create_time, income, output from fi_account ORDER BY id DESC LIMIT {(int(page) - 1) * size},{size}"
            query_res = LinkMysql(env.DB_3YV2).query_mysql(data_sql)
        if not query_res:
            return [], 0
        # 多线程
        ths = []
        # 创建线程
        for x in range(len(query_res)):
            ths.append(threading.Thread(target=self.thead_task, args=[query_res[x]]))
        # 启动线程
        for y in range(len(query_res)):
            ths[y].start()
        # 等待全部结束,再结束
        for z in range(len(query_res)):
            ths[z].join()
        self.result_list.sort(key=lambda q: q['id'], reverse=True)
        return self.result_list, count


def get_gift_type():
    """礼物类型"""
    out_list = []
    income_list = []
    gift_sql = "select id,keyName,keyValue,type from fi_account_type"
    output = LinkMysql(env.DB_3YV2).query_mysql(gift_sql)
    for info in output:
        if info.get("type") == 1:
            income_list.append(info)
        else:
            out_list.append(info)
    return {"income": income_list, "output": out_list}


def create_account(param):
    """创建账户"""
    try:
        income = ','.join(map(str, param.income))
        output = ','.join(map(str, param.output))
        sql = f"insert into fi_account(name, unique_tag, config_key, description, uuid, income, output, create_time) " \
              f"values('{param.name}', '{param.unique_tag}', '{param.config_key}', '{param.remark}', '{uuid()}', '{income}', '{output}', {get_now_timestamp()});"
        account = LinkMysql(env.DB_3YV2).perform_mysql(sql)
    except Exception as e:
        print(e)
        if 'config_key' in str(e):
            return 'config_key重复'
        return e
    return ''


def update_account_info(old_data):
    """修改账户"""
    income = ','.join(map(str, old_data.income))
    output = ','.join(map(str, old_data.output))
    try:
        sql = f"update fi_account set name='{old_data.name}',income='{income}', output='{output}', " \
              f"description='{old_data.remark}' where id = {old_data.id}"
        LinkMysql(env.DB_3YV2).perform_mysql(sql)
    except Exception as e:
        print(e)


def get_finance_info(unique_tag, page, size, start_time, end_time, is_list=None):
    """账户财务信息"""
    finance_condition = []
    if start_time:
        finance_condition.append(f"create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
    if end_time:
        finance_condition.append(f"create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
    if unique_tag == 'guild_account':
        if finance_condition:
            count_sql = f"select calculation_time from v3_guild_account_statistics_copy where  {' and '.join(finance_condition)} GROUP BY create_time"
            data_sql = f"select id,initial_money as balance,income,outcome,create_time from v3_guild_account_statistics_copy where  {' and '.join(finance_condition)} GROUP BY create_time order by create_time DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select calculation_time from v3_guild_account_statistics_copy GROUP BY create_time"
            data_sql = f"select id,initial_money as balance,income,outcome,create_time from v3_guild_account_statistics_copy GROUP BY create_time order by create_time DESC limit {(int(page) - 1) * size},{size}"
    elif unique_tag == 'user_account':
        if finance_condition:
            condition = [i.replace('create_time', 'calculation_time') for i in finance_condition]
            count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=1 and {' and '.join(condition)} GROUP BY calculation_time"
            data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=1 and {' and '.join(condition)} GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=1 GROUP BY calculation_time"
            data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=1 GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
    elif unique_tag == 'knapsack_account':
        if finance_condition:
            condition = [i.replace('create_time', 'calculation_time') for i in finance_condition]
            count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=4 and {' and '.join(condition)} GROUP BY calculation_time"
            data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=4 and {' and '.join(condition)} GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=4 GROUP BY calculation_time"
            data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=4 GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
    elif unique_tag == 'pledgeDeduction':
        if finance_condition:
            condition = [i.replace('create_time', 'calculation_time') for i in finance_condition]
            count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=5 and {' and '.join(condition)} GROUP BY calculation_time"
            data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=5 and {' and '.join(condition)} GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=5 GROUP BY calculation_time"
            data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=5 GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
    else:
        if finance_condition:
            count_sql = f"select create_time from v2_system_account_statistics_copy where {' and '.join(finance_condition)} GROUP BY create_time"
            data_sql = f"select id,initial_money as balance,income,outcome,create_time from v2_system_account_statistics_copy where {' and '.join(finance_condition)}  GROUP BY create_time order by create_time DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select create_time from v2_system_account_statistics_copy GROUP BY create_time"
            data_sql = f"select id,initial_money as balance,income,outcome,create_time from v2_system_account_statistics_copy GROUP BY create_time order by create_time DESC limit {(int(page) - 1) * size},{size}"
    with ThreadPoolExecutor(max_workers=2) as pool:
        future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, count_sql)
        future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, data_sql)
    count = future1.result()
    res = future2.result()
    # 判断是列表还是导出接口
    if is_list:
        return res, len(count)
    else:
        return res


def get_finance_details(page, size, uuid, start_time, end_time, type, gift_type, is_list=None):
    """账户财务明细"""

    details_condition = [f" uuid='{uuid}' "]
    if type or type == 0:
        details_condition.append(f" type={type}")
    if gift_type:
        details_condition.append(f" reference_type like '%{gift_type}%'")
    if start_time:
        details_condition.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
    if end_time:
        details_condition.append(f" create_time <= {time_str_to_timestamp(end_time + ' 23:59:59')} ")
    year_month = datetime.now().strftime('%Y%m')
    if details_condition:
        count_sql = f"select count(id) as num from assets_log_{year_month} where {' and '.join(details_condition)}"
        data_sql = f"select id,order_number,type,reference_type,amount/1000 as amount,create_time from assets_log_{year_month} where {' and '.join(details_condition)} order by id DESC limit {(int(page) - 1) * size},{size}"
        amount_sql = f"select sum(cast(amount as decimal(20,6)))/1000 as total_amount from assets_log_{year_month} where {' and '.join(details_condition)}"

    else:
        count_sql = f"select count(id) as num from assets_log_{year_month}"
        data_sql = f"select id,order_number,type,reference_type,amount/1000 as amount,create_time from assets_log_{year_month} order by id DESC limit {(int(page) - 1) * size},{size}"
        amount_sql = f"select sum(cast(amount as decimal(20,6)))/1000 as total_amount from assets_log_{year_month}"
    with ThreadPoolExecutor(max_workers=3) as pool:
        future1 = pool.submit(LinkMysql(env.DB_HISTORY).query_mysql, count_sql)
        future2 = pool.submit(LinkMysql(env.DB_HISTORY).query_mysql, data_sql)
        future3 = pool.submit(LinkMysql(env.DB_HISTORY).query_mysql, amount_sql)
    total = future1.result()
    res = future2.result()
    amount_res = future3.result()

    # 判断是列表还是导出接口
    if is_list:
        if not res:
            return [], 0, 0
        for i in res:
            i['reference_name'] = TYPE_NAME[i['reference_type']] if TYPE_NAME[i['reference_type']] else i['reference_type']
        return res, total[0]['num'], amount_res[0]['total_amount']
    else:
        return res


def get_account_type(db: Session, **data):
    """礼物类型配置列表"""
    finance_filters = []
    if data.get("key_name"):
        finance_filters.append(AccountType.key_name == data.get("key_name"))
    if data.get("key_value"):
        finance_filters.append(AccountType.key_value == data.get("key_value"))
    if data.get("type") or data.get("type") == 0:
        finance_filters.append(AccountType.type == data.get("type"))
    querydata, count = QueryAllData(db, AccountType, data, finance_filters).query_data()
    data = [QueryAllData.serialization(item) for item in querydata]
    return data, count


def update_account_type(db: Session, data):
    """修改账目类型"""
    try:
        db.query(AccountType).filter(AccountType.id == data.id).update({AccountType.key_name: data.key_name,
                                                                        AccountType.key_value: data.key_value,
                                                                        AccountType.type: data.type})
        db.commit()
        return True
    except Exception as e:
        print(e)
        return False


def get_account_type_value(db: Session, key):
    """新建类型 查询是否有重复数据"""
    return db.query(AccountType).filter(AccountType.key_value == key).first()


def create_type(db: Session, data):
    """创建新账目类型"""
    try:
        db_type = AccountType(key_name=data.key_name, key_value=data.key_value, type=data.type,
                              create_time=datetime.now())
        db.add(db_type)
        db.commit()
        db.refresh(db_type)
    except Exception as e:
        print(e)
        return {}
    return db_type
