
import uvicorn

from fastapi import Depends, FastAPI,Request,Response, HTTPException,status
from starlette.middleware.cors import CORSMiddleware

# from core.dependencies.base_dependen import get_query_token, get_token_header
# from internal import admin
from app.users.router import router as users_router
from core.dependencies.auth_dependen import router as token_router

app = FastAPI(
    title='demo',
    description='',
    version='1.0.0')

# 包含子模块的路由
app.include_router(users_router, tags=['users'])
# app.include_router(admin.router, prefix='/admin', tags=['admin'] )
app.include_router(token_router, tags=['token'])

# 可选,独立定义根路由
@app.get('/',tags=['root'])
async def root():
    return {'message': 'Hello demo Applications!'}

# 设置允许访问的域名
origins = ['*']  #可以设置为'*'，即为所有。

# 设置跨域传参
app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,  # 设置允许的origins来源
    allow_credentials=True,
    allow_methods=['*'],  # 设置允许跨域的http方法，比如 get、post、put等。
    allow_headers=['*'])  # 允许跨域的headers，可以用来鉴别来源等作用。


# if __name__ == '__main__':
#     uvicorn.run(app,debug=True) 