from pydantic import BaseModel


class UserBase(BaseModel):
    username: str


class UserCreate(UserBase):
    unique: str
    description: str
    config_key: str


class User(UserBase):
    id: int

    class Config:
        orm_mode = True
