from typing import Optional
from pydantic import BaseModel, validator
from pydantic import ValidationError


class ExportList(BaseModel):
    source: Optional[str] = ""
    start_time: Optional[str] = ""
    end_time: Optional[str] = ""
    page: Optional[int] = None
    size: Optional[int] = None


class ExportUpdateData(BaseModel):
    id: int
    remark: str = ""


class MonthStatistics(BaseModel):
    date: str = ""
    type: str = ""
    name: str = ""
    page: int = None
    size: int = None


class MonthDetails(MonthStatistics):
    key: str
    is_income: int

    # @validator('key')
    # def key_must_contain_space(cls, v):
    #     if ' ' not in v:
    #         raise ValidationError('缺少必传参数key')
    #     return v.title()
