import json
import socket
from concurrent.futures.thread import ThreadPoolExecutor

from app.api.statement.guild import query_token
from core.config.env import env
from libs.db_link import LinkMysql
from libs.functions import time_str_to_timestamp, get_now_timestamp, get_order, get_now_datetime, \
    send_json_rpc_request
from libs.log_utils import Logger
from libs.token_verify import get_current_user


def get_margin(guild_id, status, page, size, start_time, end_time):
    """保证金列表，查询"""
    guild_filters = []
    guild_filters.append(f" m.type=1")
    if guild_id:
        guild_filters.append(f" m.guild_id={guild_id}")
    if status:
        guild_filters.append(f" m.status={status}")
    if start_time:
        guild_filters.append(f" m.addtime >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
    if end_time:
        guild_filters.append(f" m.addtime <= {time_str_to_timestamp(end_time + ' 23:59:59')} ")
    if guild_filters:
        count_sql = f"select count(id) as num from guild_margin_history as m where {' and '.join(guild_filters)}"
        data_sql = f"select m.id,m.guild_id,g.guild_name,amount,m.status,m.addtime as create_time from guild_margin_history m inner join guild g on m.guild_id=g.id where {' and '.join(guild_filters)} order by id DESC limit {(int(page) - 1) * size},{size}"
    else:
        count_sql = f"select count(id) as num from guild_margin_history"
        data_sql = f"select m.id,m.guild_id,g.guild_name,amount,m.status,m.addtime as create_time from guild_margin_history m inner join guild g on m.guild_id=g.id order by id DESC limit {(int(page) - 1) * size},{size}"
    with ThreadPoolExecutor(max_workers=2) as pool:
        future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, count_sql)
        future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, data_sql)
    total = future1.result()
    res = future2.result()
    return res, total[0]


class GuildMargin(object):
    def __init__(self, db, header):
        self.db = db
        user = query_token(self.db, header)
        self.user_id = user.get("user_id")

    def margin_dispose(self, param):
        # 查询公会
        guild_sql = f"select id,margin,ice_uuid,guild_level_id,withdrawal_time,pay_status,is_lucky_gift,is_binding,bind_authority,pledge_rate from guild where id={param.guild_id} limit 0,1"
        guid_list = LinkMysql(env.DB_3YV2).query_mysql(guild_sql)
        if not guid_list:
            return '公会不存在'
        guid_info = guid_list[0]
        # 拒绝
        if param.examine_status == -1:
            refuse_sql = f"update guild_margin_history set status=5 where id={param.id}"
            LinkMysql(env.DB_3YV2).perform_mysql(refuse_sql)
            return '拒绝成功'

        try:
            # 修改公会保证金记录 状态
            agree_sql = f"update guild_margin_history set status=4 where id={param.id}"
            LinkMysql(env.DB_3YV2).perform_mysql(agree_sql)
        except Exception as e:
            Logger(40).logger.error(f"修改保证金记录-状态-失败：{str(e)}")
            return '操作失败'
        # 给公会添加保证金
        agree_sql = f"update guild set margin={float(guid_info.get('margin')) + param.amount} where id={param.guild_id}"
        LinkMysql(env.DB_3YV2).perform_mysql(agree_sql)
        # 添加保证金添加记录
        try:
            add_sql = f"insert into guild_pledge_record(guild_id, before_pears, after_pears, create_time, update_time, tixian_id, is_handle, pledge_pearl,margin) " \
                      f"values({param.guild_id}, {guid_info.get('margin')}, {float(guid_info.get('margin')) + param.amount}, {get_now_timestamp()}, {get_now_timestamp()}, 0, 1, 0,{param.amount});"
            LinkMysql(env.DB_3YV2).perform_mysql(add_sql)
        except Exception as e:
            Logger(40).logger.error(f"添加保证金失败：{str(e)}")
            return '操作失败'
        # 对接财务 充值
        self.recharge_user(guid_info.get('ice_uuid'), param.amount, param.guild_id)
        # 调整公会权限
        self.guild_authority(param.guild_id, param.amount, guid_info)
        return '操作成功'

    def recharge_user(self, ice_uuid, money, guild_id, reference_type='marginRecharge', timestamp=None):
        timestamp = timestamp if timestamp else get_now_timestamp()
        reference_number = get_order()
        ip = socket.gethostbyname(socket.gethostname())
        request_data = {
            'uuid': ice_uuid,
            'timestamp': timestamp,
            'ip': ip,
            'amount': money,
            'amount_type': 'withdrawable',
            'reference_number': reference_number,
            'reference_type': reference_type,
            'reference_info': '保证金充值',
        }
        res = send_json_rpc_request(request_data, 'Server.UserExecute.Recharge')
        Logger().logger.info(f"清算recharge_user结果：{str(res)}")
        res['_sql'] = []
        insert_sql = f"insert into all_record_table(user_id, type, status, uuid, reference_number, money, amount_type, money_data, is_add, create_time, errmsg) " \
                     f"values({guild_id}, '{reference_type}', 2, '{ice_uuid}', {reference_number}, {money * 10}, 1, '保证金充值',1,{timestamp}, '{json.dumps(res)}');"
        if res['status'] == 9:
            insert_sql = f"insert into all_record_table(user_id, type, status, uuid, reference_number, money, amount_type, money_data, is_add, create_time, errmsg) " \
                         f"values({guild_id}, '{reference_type}', 9, '{ice_uuid}', {reference_number}, {money * 10}, 1, '保证金充值',1,{timestamp}, '{json.dumps(res)}');"
        if res['status'] == False:
            insert_sql = f"insert into all_record_table(user_id, type, status, uuid, reference_number, money, amount_type, money_data, is_add, create_time, errmsg) " \
                         f"values({guild_id}, '{reference_type}', 3, '{ice_uuid}', {reference_number}, {money * 10}, 1, '保证金充值',1,{timestamp}, '{json.dumps(res)}');"
            Logger().logger.info(f'保证金错误,订单号：{reference_number}')
        LinkMysql(env.DB_3YV2).perform_mysql(insert_sql)

    def guild_authority(self, guild_id, amount, guild_info):
        if not guild_id:
            return False
        global_sql = "select v from global_config where k='guild_level' limit 0,1"
        res = LinkMysql(env.DB_3YV2).query_mysql(global_sql)
        if not res:
            return False
        con = res[0]['v']
        config = json.loads(con)
        if (float(guild_info.get('margin')) - amount) < float(config['margin']) and float(guild_info.get('margin')) >= float(config['margin']):
            content_dict = {
                'withdrawal_time': {'name': '提现周期', 'type': 'value'},
                'pay_status': {'name': '充值权限', 'type': 'radio'},
                'is_lucky_gift': {'name': '幸运奖励权限', 'type': 'radio'},
                'is_binding': {'name': '红包绑定权限', 'type': 'radio'},
                'bind_authority': {'name': '分享者绑定权限', 'type': 'radio'},
                'pledge_rate': {'name': '质押金比例', 'type': 'value'},
            }
            # 获取配置的key
            temp_key = guild_info.get('guild_level_id') - 1
            update = {}
            content = ''
            for k, v in content_dict.items():
                if guild_info[k]:
                    if v['type'] == 'radio':
                        while config['high'][k][temp_key]:
                            if config['high'][k][temp_key] == '0':
                                if guild_info[k] != 0:
                                    update[k] = 0
                                    content += f"{v['name']}由开启修改为关闭,"
                                break
                            if config['high'][k][temp_key] == '1':
                                break
                            if config['high'][k][temp_key] == '2':
                                if guild_info[k] != 1:
                                    content += f"{v['name']}由关闭自动修改为开启,"
                                break
                    else:
                        if guild_info[k] != config['high'][k][temp_key]:
                            update[k] = config['high'][k][temp_key]
                            content += f"{v['name']}由{guild_info[k]}修改为{config['high'][k][temp_key]},"
            if update:
                update_list = [f"{k}={float(v)}" for k, v in update.items()]
                update_sql = f"update guild set {','.join(update_list)} where id={guild_id}"
                LinkMysql(env.DB_3YV2).perform_mysql(update_sql)
                insert_guild_sql = f"insert into guild_authority_record(content, json, create_time, admin_id, guild_id, type, reason) " \
                                   f"values('{content}', '{json.dumps(update)}', {get_now_timestamp()}, {self.user_id}, {guild_id}, 2, '公会缴纳保证金{amount}后保证金总数为{float(guild_info['margin']) + amount}高于配置金额，权限由低位调整到高位');"
                LinkMysql(env.DB_3YV2).perform_mysql(insert_guild_sql)
