import datetime
import json
import time
import requests
from core.config.env import env
from libs import functions
from libs.log_utils import Logger


def retry(number=1):
    """
    最外层传递装饰器参数(这一层可以不写)
    中间层传递被装饰器装饰的函数,这里相当于get()
    内层传递被装饰器装饰函数的参数,这里是get()的参数a
    装饰器作用:限制request重复请求的次数
    """

    def outer(func):
        def inner(database_name, mon_sql, field_list):
            num = 1
            res_data = 0
            for i in range(number):
                try:
                    res_data = func(database_name, mon_sql, field_list)
                    break
                except Exception as e:
                    Logger(21).logger.info(f"------------JDBC超时或者失败{i + 1}次-----------")
                    time.sleep(1)
                    num += 1
                    if num == 3:
                        now_time = functions.get_now_datetime()
                        environment = "正式环境"
                        if 'dev' in env.TX_URL:
                            environment = "测试环境"
                        msg = {
                            "error_time": now_time,
                            "error_env": environment,
                            "error_line": str(e.__traceback__.tb_frame.f_globals["__file__"]) + ':' + str(
                                e.__traceback__.tb_lineno),
                            "error_info": str(e),
                            "query_sql": str(mon_sql)
                        }
                        Logger(21).logger.error("腾讯数据库查询异常:" + str(msg))
                        return res_data
            return res_data
        return inner
    return outer


@retry(number=2)
def tx_query_num(database_name, mon_sql, field_list):
    """
    查询腾讯sql总数语句
    :param database_name 数据库
    :param mon_sql 查询sql
    :param field_list 要返回的字段
    :return 0
    """
    data = {
        "sql_sentence": mon_sql,
        "database_name": database_name,
        "expiretime": 10,
        "fields": field_list
    }

    start_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    res = requests.post(url=env.TX_URL, json=data)
    end_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    if res.status_code != 200:
        raise Exception(res.text)
    content = json.loads(res.text)
    Logger(21).logger.info(f"数据库查询sql:{str(mon_sql)}，结果：{str(content)}，开始时间：{str(start_time)},结束时间：{str(end_time)}")
    if content.get("code") == 200:
        row = content.get("rows")[0]
        amount = row.get("amount")
        if not amount:
            amount = 0
    else:
        amount = 0

    return amount


@retry(number=2)
def tx_query_list(database_name, mon_sql, field_list):
    """
    查询sql语句
    :param database_name
    :param mon_sql
    :param field_list
    :return []
    """
    data = {
        "sql_sentence": mon_sql,
        "database_name": database_name,
        "expiretime": 10,
        "fields": field_list
    }
    start_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    res = requests.post(url=env.TX_URL, json=data)
    end_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    if res.status_code != 200:
        raise Exception(res.text)
    content = json.loads(res.text)
    Logger(21).logger.info(
        f"数据库查询sql:{database_name}---结果：{content.get('code')}---，开始时间：{start_time},结束时间：{end_time}")
    if res.status_code == 200:
        row = content.get("rows")
        if not row:
            row = []
    else:
        row = []
    return row
