
from sqlalchemy import Column, Integer, String, Text, DateTime, Float,DECIMAL
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class Guild(Base, SerializerMixin):
    """公会表"""
    __tablename__ = "guild"

    id = Column(Integer, primary_key=True, index=True)
    merchants_id = Column(Integer, comment="招商id")
    guild_name = Column(String(255), default='', comment="公会名称")
    guild_per = Column(String(10), comment="公会比例")
    guild_card = Column(String(255), comment="身份证号码")
    parentid = Column(Integer, default=0, comment="父级ID")
    parentids = Column(String(150), comment="父级类别")
    merchants_per = Column(Integer, default=0, comment="招商比例")
    current = Column(Integer, default=0)
    guild_level = Column(Integer, default=1)
    user_id = Column(Integer, comment="公会所有人id")
    anchor_default_per = Column(String(10), default='0', comment="主播默认比例")
    user_default_per = Column(String(10), default='0', comment="分享者默认比例，两者比例不能超过公会比例")
    anchor_max_per = Column(String(10))
    user_max_per = Column(String(10))
    anchor_min_per = Column(String(10))
    redbox_sta = Column(Integer, default=0, comment='是否开启红包0否1是')
    redbox_per = Column(String(10), default=0, comment='红包收续费百分比')
    user_min_per = Column(String(10))
    remark = Column(Text, comment="公会简介")
    status = Column(Integer, default=0, comment="-1:结算状态 0，有效，1无效 2:待审核 3:驳回")
    contacts = Column(String(255), comment="联系人")
    mobile = Column(String(255), comment="联系电话")
    total = Column(Float, default=0.00, comment="公会收益计算(人民币)")
    genuine_pearl = Column(Float, default=0.00, comment="珍珠数")
    frost_genuine_pearl = Column(Float, default=0.00, comment="冻结珍珠数(真)[当前用于幸运礼物奖励]")
    fake_frost_genuine_pearl = Column(Float, default=0.00, comment="冻结珍珠数(假)[当前用于幸运礼物奖励]")
    rand_genuine_pearl = Column(Float, default=0.00, comment="冗余珍珠数[当前用户幸运礼物奖励]")
    merchants_pearl = Column(Float, default=0.00, comment="招商珍珠数")
    type = Column(Integer, default=1, comment="1:普通公会 2.普通招商公会 3.签约公会 4.签约招商公会")
    quality = Column(Integer, default=1, comment="1:个人 2:公司")
    company_name = Column(String(255), comment="公司名称")
    company_juridical_person = Column(String(150), comment="法人")
    guild_level_id = Column(Integer, default=0, comment="公会等级")
    guild_generalize = Column(Float, default=0.00, comment="公会推广收益")
    status_time = Column(Integer, comment="被禁用时间")
    weixin = Column(String(50), comment="微信号")
    business_license = Column(String(255), comment="营业执照")
    audit_time = Column(Integer, default=0, comment="审核时间")
    audit_remark = Column(String(255), comment="驳回原因")
    guild_no = Column(String(30), comment="工会账号")
    guildPwd = Column(String(100), default='', comment="密码")
    guildPwdStr = Column(String(30), default='', comment="密码明文")
    guild_no_switch = Column(Integer, default=1, comment="是否启用公会充值账号权限： 1:开启  2： 关闭")
    guild_no_limit = Column(String(100), comment="公会账号配置(json)： 键名：startHour、endHour、singleLimit、dayLimit")
    guildMobile = Column(String(100), default='', comment="充值账号绑定的手机号")
    today_redbox_num = Column(Integer, default=-1, comment="每日红包数量")
    today_redbox_money = Column(Integer, default=-1, comment="每日红包总量")
    month_redbox_money = Column(Integer, default=-1, comment="每月红包总量")
    idcard_face = Column(String(255))
    idcard_back = Column(String(255))
    pay_status = Column(Integer, default=1, comment="公会用余额充值钻石权限0关闭1开启")
    today_guild_pay_start = Column(Integer, default=-1, comment="公会充值开放开始时间")
    today_guild_pay_end = Column(Integer, default=-1, comment="公会充值开放结束时间")
    guild_today_pay_balance = Column(Integer, default=-1, comment="公户充值每日钻石数")
    guild_month_pay_balance = Column(Integer, default=-1, comment="公会充值每月钻石数")
    today_guild_pay_charge = Column(Integer, default=-1, comment="公会充值手续费")
    pay_pwd = Column(String(255), comment="交易密码")
    pay_phone = Column(String(20), default='0', comment="交易密码手机号")
    pay_see_sta = Column(Integer, default=0, comment="是否查看协议")
    see_money_sta = Column(Integer, default=1, comment="0不可看1可看")
    is_ban = Column(Integer, default=0, comment="工会是否被后台封禁 0:正常 1:被封禁")
    is_disband = Column(Integer, default=0, comment="公会是否被解散，0 没有 1 被解散")
    bindnum = Column(Integer, default=0, comment="公会可绑定人数")
    last_keyword = Column(String(255), default='', comment="上一次查询的朱贝号")
    over_limit_ratio = Column(String(10), default=-1, comment="超出充值钻石比")
    investment_ids = Column(String(20), default='', comment="公会招商权限，1：普通，2：普通招商，3：签约，4：签约招商")
    last_login_time = Column(Integer, default=0, comment="上次登录时间")
    margin = Column(Float, default=0.00, comment="公会保证金")
    attract_investment_money = Column(Float, default=0.00, comment="招商收益不计入直播收益")
    balance = Column(Float, default=0.000, comment="钻石余额")
    pay_margin = Column(Integer, default=0, comment="是否缴纳过保证金，0:没有 1:有")
    is_lucky_gift = Column(Integer, default=1, comment="幸运礼物是否开启，1为开启，0为未开启")
    is_binding = Column(Integer, default=1, comment="默认开启绑定,，1为开启，0为未开启")
    first_jurisdiction = Column(Integer, default=0, comment="手动修改为最高优先1 幸运 2 绑定 4 充值 8 手续费 16 提现方式 32分享者绑定")
    uuid = Column(String(100), default=0)
    bind_authority = Column(Integer, default=1, comment="公会分享者绑定权限")
    exchange_pearl_authority = Column(Integer, default=1, comment="公会分兑换珍珠权限")
    pick_pearl_authority = Column(Integer, default=1, comment="公会分拾取珍珠权限")
    withdrawal_time = Column(Integer, default=0, comment="提现时间,目前是具体的天数,0-7")
    settlement_time = Column(Integer, default=24, comment="钻石结算周期小时")
    idcard_sc = Column(String(255), default=24, comment="手持身份证")
    business_license_sc = Column(String(255), comment="手持营业执照")
    videoaddress = Column(String(255), comment="承诺视频地址")
    make_up_the_difference = Column(Integer, default=0, comment="1开启，默认0关闭")
    source = Column(Integer, default=0, comment="新增公会来源：0-公会后台，1-总后台")
    v2_user_id = Column(Integer, default=0, comment="主播创建自由公会用户id")
    ice_gift = Column(Integer, default=0, comment="是否可以自由解除冻结幸运礼物，0：不能 1：可以")
    ty_school = Column(Integer, default=0, comment="是否为天颜培训机构公司（0-否，1-是）")
    pledge_pearl = Column(Float, default=0.00, comment="质押金（元）")
    user_pledge_pearl = Column(Float, default=0.00, comment="用户可提现的质押金（元）")
    pledge_rate = Column(Float, default=0.00, comment="质押金比例")
    ice_uuid = Column(String(100), default='', comment="冻结账户uuid")
    is_open_user_frozen = Column(Integer, default=2, comment="是否开通财务冻结账户 1为开通 2为没有开通")
    partner = Column(Integer, default=0, comment="合作方，0为平台，1为上级")
    settlement = Column(Integer, default=0, comment="是否已结算")
    rescind = Column(Integer, default=0, comment="0未解约，1解约")
    update_time = Column(Integer, default=0, comment="修改时间")
    can_do_trans = Column(Integer, default=1, comment="1,不能转账 2,可以转账")
    trans_fee = Column(Float, comment="转账手续费,单精度")
    master_user_number = Column(Integer, comment="公会长朱贝号")
    package_group_id = Column(Integer, default=0, comment="包分组id")
    investment_switch = Column(Integer, default=0, comment="1:开启 0关闭 ，招商管理权限开关")
    operation_pwd = Column(String(255), default=0, comment="操作密码")

    __table_args__ = {'comment': '公会表'}


class GuildPledgeRecord(Base, SerializerMixin):
    """公会质押记录表"""
    __tablename__ = 'guild_pledge_record'
    id = Column(Integer, primary_key=True, index=True)
    guild_id = Column(Integer, default=0, comment="公会id")
    before_pears = Column(Float, comment="变动前金额(元)")
    after_pears = Column(Float, comment="变动后金额（元）")
    create_time = Column(DateTime, comment="创建时间")
    update_time = Column(DateTime, comment="修改时间")
    tixian_id = Column(Integer, comment="提现id")
    is_handle = Column(Integer, default=2, comment="是否处理 2表示未处理 1为处理")
    pledge_pearl = Column(Float, default=0.00, comment="质押金(元)")
    margin = Column(Float, default=0.00, comment="保证金（元）")

    __table_args__ = {'comment': '公会质押记录表'}


class GuildSettlementLog(Base, SerializerMixin):
    """工会申请结算统计表"""
    __tablename__ = 'guild_log'
    id = Column(Integer, primary_key=True, index=True)
    work_id =Column(Integer, comment="业务id")
    guild_id = Column(Integer, comment="公会id")
    balance = Column(DECIMAL(15,3),default='0.000',comment="结算时的钻石,RMB单位")
    bank_name =Column(String(122), comment="开户行名称")
    bank_no =Column(String(122), comment="账户名称")
    guild_name =Column(String(122), comment="公会名字")
    pearl = Column(DECIMAL(15,3),default='0.000', comment="结算时候的珍珠，RMB单位")
    status = Column(Integer, comment="0待结算，1待结款，2已完成,3结算失败")
    create_time = Column(Integer,default='0',comment="创建时间")
    update_time = Column(Integer,default='0',comment="修改时间")
    account_name = Column(String(122), comment="户头名称")
    guild_per = Column(String(122), comment="公会比例")
    actual_money = Column(DECIMAL(15,3), default='0.000', comment="实际结款")
    pledge_deposit_money = Column(DECIMAL, default='0.000', comment="质押金金额")

    __table_args__ = {'comment': '公会质押记录表'}


