import base64
import os.path
import random
import string
import requests
import socket
from PIL import Image, ImageFont, ImageDraw
from six import BytesIO

from core.config.env import client, Bucket, secret_key, region, secret_id, COS_PATH, COS_RERURN_PATH, red

session = requests.session()


class imageCode():
    '''
    验证码处理
    '''

    def rndColor(self):
        '''随机颜色'''
        return (random.randint(32, 127), random.randint(32, 127), random.randint(32, 127))

    def geneText(self):
        '''生成4位验证码'''
        return ''.join(random.sample(string.ascii_letters + string.digits, 4))  # ascii_letters是生成所有字母 digits是生成所有数字0-9

    def drawLines(self, draw, num, width, height):
        '''划线'''
        for num in range(num):
            x1 = random.randint(0, width / 2)
            y1 = random.randint(0, height / 2)
            x2 = random.randint(0, width)
            y2 = random.randint(height / 2, height)
            draw.line(((x1, y1), (x2, y2)), fill='black', width=1)

    def getVerifyCode(self):
        '''生成验证码图形'''
        code = self.geneText()
        # 图片大小120×50
        width, height = 120, 50
        # 新图片对象
        im = Image.new('RGB', (width, height), 'white')
        # 字体
        font_file = os.path.join(os.getcwd(), "static", "DejaVuSans-BoldOblique.ttf")
        font = ImageFont.truetype(font_file, 40)
        # draw对象
        draw = ImageDraw.Draw(im)
        # 绘制字符串
        for item in range(4):
            draw.text((5 + random.randint(-3, 3) + 23 * item, 5 + random.randint(-3, 3)),
                      text=code[item], fill=self.rndColor(), font=font)
        # 划线
        self.drawLines(draw, 2, width, height)
        return im, code

    def getImgCode(self):
        image, code = self.getVerifyCode()
        # 图片以二进制形式写入
        buf = BytesIO()
        image.save(buf, 'jpeg')
        buf_str = buf.getvalue()
        img = b"data:image/png;base64," + base64.b64encode(buf_str)
        session.headers['verify'] = code
        res = socket.gethostbyname(socket.gethostname())
        red.set(res + '-VerifyCode', code, 100)
        return img.decode('utf-8')


def new_upload_file(file_object,filename):
    '''图片上传cos'''
    filename = COS_RERURN_PATH+filename+'.png'
    try:
        response = client.put_object(
            Bucket=Bucket,
            Body=file_object,
            Key=filename,
        )
    except Exception as e:
        print("上传失败")
        return ""
    if response is None:
        print("上传成功")
    return filename


def random_number():
    randomId = ''.join([str(random.randint(1, 999999)).zfill(3) for _ in range(2)])
    return randomId