from app.api.statement import crud, schemas
from fastapi import APIRouter
from libs.result_format import HttpResultResponse

router = APIRouter()


@router.post("/recharge/list")
def statement_recharge_list(data: schemas.StatementList):
    """充值报表列表"""
    statement_list = crud.get_statements(data)
    return HttpResultResponse(data=statement_list)


@router.post("/derive/excel")
def statement_recharge_list(data: schemas.StatementList):
    """导出"""
    statement_list = crud.get_statements(data)
    return crud.data_to_file(statement_list, "充值报表")
