from typing import Optional
from pydantic import BaseModel, validator


class StatementBase(BaseModel):
    user_id: int
    zb_number: int
    order_number: int


class StatementCreate(StatementBase):

    nickname: str
    recharge_amount: float
    recharge_channel: str
    flowing_water_number: int


class StatementList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    start_time:  Optional[str] = ""
    end_time: Optional[str] = ""
    order_number: Optional[str] = ""
    user_id: Optional[str] = ""
    sid: Optional[str] = ""
    paychannel: Optional[str] = ""


class Statement(StatementBase):
    id: int

    class Config:
        orm_mode = True


class UserWithdrawalList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    start_time:  Optional[str] = ""
    end_time: Optional[str] = ""
    status: Optional[int] = None
    user_id: Optional[int] = None


class GuildWithdrawalList(BaseModel):
    page: int
    size: int
    start_time: str =None
    end_time: str=None
    status: int=None
    guild_id: int=None




class PaymentWithdrawalList(BaseModel):
    page:int =None
    size:int =None
    start_time: str =None
    end_time: str=None
    status: int=None
    guild_id: int=None


    @validator('start_time')
    def validate_start_time(cls, val):
        if val !='':
            return val

    @validator('end_time')
    def validate_end_time(cls, val):
        if val !='':
            return val

    @validator('status')
    def validate_status(cls, val):
        if val !='':
            return val

    @validator('guild_id')
    def validate_guild_id(cls, val):
        if val !='':
            return val

class PaymentAdd(BaseModel):
      uuid:str
      money:int
      cont:str
      url:str
      def __str__(self):
          return "uuid：%s, money：%s" % (str(self.uuid), self.money)



class PaymentAccountlList(PaymentWithdrawalList):

      uuid : int=None



class GuildUpdate(BaseModel):
    id: int
    status: int
