from sqlalchemy import Column, Integer, String, Text, DateTime, Float
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class ExportFile(Base, SerializerMixin):
    """账户表"""
    __tablename__ = "export_record"

    id = Column(Integer, primary_key=True, index=True)
    operator = Column(String(10), comment="操作人")
    source = Column(String(50), comment="请求来源标识，方便扩展，比如财务后台、总后台、公会后台等")
    method = Column(String(50), comment="哪个方法进行的导出")
    params = Column(Text, comment="json格式的请求参数")
    identify = Column(String(32), comment="md5的params值，用于和method一起做查询")
    status = Column(Integer, default=0, comment="执行状态 0:待执行 1:成功 2:失败,3:无数据导出")
    remark = Column(Text, comment="备注")
    url = Column(String(200), comment="文件地址")
    create_time = Column(DateTime, comment="创建时间")
    update_time = Column(DateTime, comment="更新时间")

    __table_args__ = {'comment': '导出文件记录'}
