import math
import time
import openpyxl
import threading
import pandas as pd
from app.api.statement.guild import query_token
from starlette.responses import StreamingResponse
from app.api.export import crud
from libs.log_utils import Logger


class Export(object):
    def __init__(self, db, data, name, header, field_list):
        self.db = db
        self.data = data
        self.name = name
        self.header = header
        self.field_list = field_list
        self.lock = threading.Lock()
        self.wb = openpyxl.Workbook()  # 创建一个新的 Excel 文件
        self.sheet = self.wb.active

    def write_data(self, sheet, row, col, data):
        sheet.cell(row=row, column=col, value=data)

    # 定义写入任务
    def write_task(self, start_row, end_row, data):

        for row in range(start_row, end_row):
            with self.lock:
                index = 0
                col = 1
                if index < len(data):
                    for k, v in data[index].items():
                        self.write_data(self.sheet, row, col, v)
                        col += 1
                    index += 1

    def data_to_file(self):
        # 获取操作人
        user = query_token(self.db, self.header)
        params = {"source": self.name, "method": "data_to_file", "status": 1}
        if len(self.data) == 0:
            params["status"] = 3
        try:
            bk = pd.DataFrame(self.data)
            if self.data[0].get('create_time'):
                if isinstance(self.data[0]['create_time'], int):
                    bk['create_time'] = bk['create_time'].apply(
                        lambda x: time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(x)))
            bk.columns = self.field_list  # 修改pandas头
            write_data = bk.to_dict(orient='records')
            # 创建线程列表
            threads = []
            rows_per_thread = math.ceil(len(write_data) / 10)
            # 写入头部
            # self.wb
            for i in self.field_list:
                self.write_data(self.sheet, 1, self.field_list.index(i)+1, i)
            # 启动线程
            for i in range(10):
                start_row = i*rows_per_thread + 2 + i
                end_row = (i+1)*rows_per_thread + 2 + i
                thread = threading.Thread(target=self.write_task, args=(start_row, end_row, write_data[i*rows_per_thread:(i+1)*rows_per_thread]))
                thread.start()
                threads.append(thread)

            # 等待所有线程完成
            for thread in threads:
                thread.join()

            crud.create_export_data(self.db, params, user)

            # 保存 Excel 文件
            self.wb.save(f'static/{self.name}.xlsx')
            self.wb.close()
            file = open(f'static/{self.name}.xlsx', 'rb')
            return StreamingResponse(file,
                                     media_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')

        except Exception as e:
            Logger(40).logger.error("导出失败：%s" % str(e))
            params["status"] = 2
            crud.create_export_data(self.db, params, user)
