from pydantic import BaseModel


class UserBase(BaseModel):
    username: str


class UserCreate(UserBase):
    unique: str
    description: str
    config_key: str


class User(UserBase):
    id: int

    class Config:
        orm_mode = True


class UserLoginForm(BaseModel):
    username: str
    password: str
    verify: str


class GoogleCode(BaseModel):
    username: str


class GoogleLogin(BaseModel):
    username: str
    password: str
    google_key: str
    google_code: str


class PermissionCreate(BaseModel):

    id: int
    authority: list
