from typing import Optional

from fastapi import Depends, APIRouter, Request
from sqlalchemy.orm import Session
from app import get_db
from app.api.margin import schemas, crud
from libs.result_format import HttpResultResponse
from libs.token_verify import login_required

router = APIRouter()


@router.get("/list")
def guild_margin_list(page: int,
                      size: int,
                      guild_id: Optional[int] = None,
                      status: Optional[int] = None,
                      start_time: Optional[str] = "",
                      end_time: Optional[str] = "",
                      token=Depends(login_required)):
    """保证金列表"""
    # result, total = crud.get_margin(data.dict(exclude_none=True))
    result, total = crud.get_margin(guild_id, status, page, size, start_time, end_time)
    return HttpResultResponse(total=total.get('num'), data=result)


@router.post("/examine")
def margin_examine(data: schemas.MarginExamine, request: Request, db: Session = Depends(get_db), token=Depends(login_required)):
    """保证金确认，拒绝"""
    header_list = request.get("headers")
    result = crud.GuildMargin(db, header_list).margin_dispose(data)
    return HttpResultResponse(msg=result)
