
import uvicorn
from fastapi import FastAPI

from app.api.api_v1 import api_router
from starlette.middleware.cors import CORSMiddleware



app = FastAPI()

origins = ['*']  # 可以设置为'*'，即为所有。
    # 设置跨域传参
app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,  # 设置允许的origins来源
    allow_credentials=True,
    allow_methods=['*'],  # 设置允许跨域的http方法，比如 get、post、put等。
    allow_headers=['*'])  # 允许跨域的headers，可以用来鉴别来源等作用。

app.include_router(api_router, prefix="/api")

if __name__ == '__main__':
    uvicorn.run(app=app, host="127.0.0.1", port=8001)
