from typing import Optional
from pydantic import BaseModel, validator


class StatementBase(BaseModel):
    user_id: int
    zb_number: int
    order_number: int


class StatementCreate(StatementBase):
    nickname: str
    recharge_amount: float
    recharge_channel: str
    flowing_water_number: int


class StatementList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    start_time: Optional[str] = ""
    end_time: Optional[str] = ""
    order_number: Optional[str] = ""
    user_id: Optional[str] = ""
    sid: Optional[str] = ""
    pay_channel: Optional[str] = ""


class Statement(StatementBase):
    id: int

    class Config:
        orm_mode = True


class UserWithdrawalList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    start_time: Optional[str] = ""
    end_time: Optional[str] = ""
    status: Optional[int] = None
    name: Optional[str] = ""


class GuildWithdrawalList(BaseModel):
    page: int
    size: int
    start_time: str = None
    end_time: str = None
    status: int = None
    guild_id: int = None


class PaymentWithdrawalList(BaseModel):
    page: int = None
    size: int = None
    start_time: str = None
    end_time: str = None
    status: int = None
    guild_id: int = None

    @validator('start_time')
    def validate_start_time(cls, val):
        if val != '':
            return val

    @validator('end_time')
    def validate_end_time(cls, val):
        if val != '':
            return val

    @validator('status')
    def validate_status(cls, val):
        if val != '':
            return val

    @validator('guild_id')
    def validate_guild_id(cls, val):
        if val != '':
            return val


class PaymentAdd(BaseModel):
    uuid: str
    money: int
    cont: str
    url: str

    def __str__(self):
        return "uuid：%s, money：%s" % (str(self.uuid), self.money)


class PaymentAccountlList(PaymentWithdrawalList):
    uuid: int = None
    transfer_id: int = None
    dst_id: int = None


class GuildUpdate(BaseModel):
    id: int
    status: int


class UserNumber(BaseModel):
    id: Optional[int] = None
    uuid: Optional[str] = ""
    user_number: Optional[int] = None


class CreateBill(BaseModel):
    dst_id: str
    dst_name: str = ""
    amount: float
    transfer_id: str
    transfer_name: str = ""
    remark: str
    type: int
    nick_name: Optional[str] = ""
    transfer_type: Optional[str] = ""
