from fastapi import Depends, APIRouter
from sqlalchemy.orm import Session
from app import get_db
from app.api.margin import schemas, crud
from libs.result_format import HttpResultResponse
from libs.token_verify import login_required

router = APIRouter()


@router.post("/list")
def guild_margin_list(data: schemas.GuildMarginList, token=Depends(login_required), db: Session = Depends(get_db)):
    """保证金列表"""
    result, total = crud.get_margin(db, data.dict(exclude_none=True))
    return HttpResultResponse(total=total, data=result)


@router.post("/examine")
def margin_examine(data: schemas.MarginExamine, token=Depends(login_required), db: Session = Depends(get_db)):
    """保证金确认，拒绝"""
    result = crud.margin_dispose(db, data.dict(exclude_none=True))
    return HttpResultResponse(msg=result)
