import hashlib
import json
import socket
import time
import random
import uuid as u
from datetime import datetime, timedelta
from datetime import datetime
from dateutil.relativedelta import relativedelta
import requests

from core.config.env import env


def get_now_timestamp():
    """
    获取现在时间
    return int eg:1667664000
    """
    now_time = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    time_array = time.strptime(now_time, "%Y-%m-%d %H:%M:%S")
    return int(time.mktime(time_array))


def get_now_datetime():
    """
    获取现在时间
    return int eg:1667664000
    """
    return datetime.now().strftime('%Y-%m-%d %H:%M:%S')


def get_before_timestamp(n):
    """获取n天前时间"""
    data_str = datetime.now() - timedelta(days=int(n))
    before_n_days = data_str.strftime("%Y-%m-%d")
    return before_n_days


def get_yesterday_timestamp():
    """获取昨天时间戳"""
    data_str = datetime.now() - timedelta(days=1)
    before_n_days = data_str.strftime("%Y-%m-%d")
    time_array = time.strptime(f"{before_n_days} 00:00:00", "%Y-%m-%d %H:%M:%S")
    today_str = datetime.now().strftime('%Y-%m-%d')
    today_array = time.strptime(f"{today_str} 00:00:00", "%Y-%m-%d %H:%M:%S")
    return int(time.mktime(time_array)), int(time.mktime(today_array))


def time_str_to_timestamp(time_str):
    """时间字符串类型  转为int"""
    time_array = time.strptime(time_str, "%Y-%m-%d %H:%M:%S")
    return int(time.mktime(time_array))


def timestamp_to_time_str(time_stamp):
    """时间戳类型转  时间字符串类型"""
    time_array = time.localtime(time_stamp)
    return time.strftime("%Y-%m-%d %H:%M:%S", time_array)


def get_last_month():
    """获取三个月月份"""
    last_month = datetime.now().date() - relativedelta(months=1)
    before_last_month = datetime.now().date() - relativedelta(months=2)
    return datetime.now().strftime("%Y%m"), last_month.strftime("%Y%m"), before_last_month.strftime("%Y%m")


def md5(s):
    """md5加密"""
    sign_str = hashlib.md5()
    sign_str.update(s.encode('utf-8'))
    return sign_str.hexdigest()


def uuid():
    """生成uuid"""
    return str(u.uuid4())


def get_order():
    """生成订单号"""
    timestamp = get_now_timestamp()
    return datetime.now().strftime('%Y%m%d%H%M%S') + str(timestamp)


# 页数页码校验
def wrapper_out():
    def wrapper(func):
        def inner(db, param):
            param.page = param.page if param.page else 1
            param.size = param.size if param.size else 10
            ret = func(db, param)
            return ret
        return inner
    return wrapper


def search(params, method):
    """
    调用清算接口
    :param params: 传入参数
    :param method: 传入方法
    """
    url = env.CLEARING_CENTER_URL
    header = {
        "RPC-METHOD": method,
        "RPC-ID": '159',
        "RPC-PROTOCOL": "jsonrpc",
        "RPC-VERSION": "2.0"
    }
    response = requests.post(url=url, headers=header, json=params)
    if response.status_code != 200:
        return {}
    text = json.loads(response.text)
    return text


def get_ip():
    res = socket.gethostbyname(socket.gethostname())
    return res


def get_month_last_month(month_type):
    last_month=0
    if month_type==2:
       month_date = datetime.now().date() - relativedelta(months=1)
       last_month = month_date.strftime("%Y%m")
    now_month =datetime.now().strftime("%Y%m")
    return last_month,now_month


def time_format(utc_timestamp: int):
    days = (utc_timestamp + 3600 * 8) % 86400
    hours = int(days / 3600)
    time_str = hours
    return time_str