from app import get_db

from sqlalchemy.orm import Session
from app.api.statement import crud, schemas
from fastapi import Depends, APIRouter, HTTPException
from libs.result_format import HttpResultResponse, HttpMessage
from typing import Optional
router = APIRouter()


@router.post("/recharge/list")
def statement_recharge_list(page: int = 1, size: int = 10, db: Session = Depends(get_db)):
    """充值报表列表"""

    users = crud.get_statements(db, page=page, size=size)
    return users


@router.post("/create")
def create_user(data: schemas.StatementCreate, db: Session = Depends(get_db)):
    """添加"""

    res = crud.create_statementr(db=db, user=data)
    return HttpResultResponse(data=res.id)




