""" 
环境变量配置文件 env.py 
切换环境，修改文档后面的命令 env = ...

"""

from pydantic import BaseSettings


class Env(BaseSettings):
    DEBUG: bool = True
    TESTING: bool = False
    DATABASE_URI: str = 'sqlite://:memory:'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''


class TestingEnv(Env):
    """测试环境配置"""
    TESTING: bool = True


class ProdEnv(Env):
    """生产环境配置"""
    DATABASE_URI: str = 'mysql://user@localhost/foo'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''


env = Env()  # 开发环境
# env = TestingEnv()      # 测试环境
# env = ProdEnv()         # 生产环境
