from sqlalchemy import Column, Integer, String, DateTime, Float
from core.storage.db import Base


class User(Base):
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, index=True)
    username = Column(String(100), unique=True, index=True)
    description = Column(String(255))
    unique = Column(String(50), unique=True)
    hashed_password = Column(String(50))
    config_key = Column(String(50))
    uuid = Column(String(50))
    authority = Column(Integer)
    remaining_sum = Column(Float)
    entry_account = Column(String(255))
    out_account = Column(String(255))
    create_time = Column(DateTime)
    update_time = Column(DateTime)


class Authority(Base):
    __tablename__ = "authority"

    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(50), index=True)
    up_one_level = Column(Integer, index=True)
    create_time = Column(DateTime)
