from fastapi import Depends, APIRouter
from sqlalchemy.orm import Session
from app import get_db
from app.api.export import schemas, crud
from libs.result_format import HttpResultResponse, HttpMessage

router = APIRouter()


@router.post("/list")
def export_list(data: schemas.ExportList, db: Session = Depends(get_db)):
    """导出记录列表"""
    result, total = crud.get_export_list(db, data.dict(exclude_none=True))
    return HttpResultResponse(total=total, data=result)


@router.post("/update")
def update_export_list(data: schemas.ExportUpdateData, db: Session = Depends(get_db)):
    """导出记录修改"""
    result = crud.update_export(db, data)
    if result:
        return HttpResultResponse()
    return HttpResultResponse(code=422, msg=HttpMessage.LOSE)


@router.delete("/delete/{id}")
def delete_export_one(id:int, db: Session = Depends(get_db)):
    """导出记录删除"""
    is_delete = crud.delete_export(db, id)
    if is_delete:
        return HttpResultResponse()
    return HttpResultResponse(code=422, msg=HttpMessage.DELETE_LOSE)


@router.get("/source")
def export_source_query(db: Session = Depends(get_db)):
    """导出来源查询"""
    result = crud.get_source_data(db)
    return HttpResultResponse(data=result)
