from sqlalchemy.orm import Session
from app.api.export import schemas
from libs.functions import get_now_datetime
from libs.orm import QueryAllData
from models.export import ExportFile


def get_export_list(db: Session, param):
    """导出列表"""
    export_filters = []
    if param.get("source"):
        export_filters.append(ExportFile.source == param.get("source"))
    if param.get("start_time"):
        export_filters.append(ExportFile.create_time >= param.get("start_time"))
    if param.get("end_time"):
        export_filters.append(ExportFile.create_time >= param.get("end_time"))
    querydata, count = QueryAllData(db, ExportFile, param, export_filters).query_data()
    data = [QueryAllData.serialization(item) for item in querydata]
    return data, count


def update_export(db: Session, data):

    try:
        db.query(ExportFile).filter(ExportFile.id == data.id).update({ExportFile.remark: data.remark})
        db.commit()
    except Exception as e:
        print(e)
        return False
    return True


def delete_export(db: Session, export_id):
    """删除导出记录"""
    try:
        db.query(ExportFile).filter(ExportFile.id == export_id).delete()
        db.commit()
    except Exception as e:
        print(e)
        return False
    return True


def create_export_data(db: Session, export, operator):
    """创建导出记录"""
    try:
        db_export = ExportFile(operator=operator.get("username"), source=export.get("source"), method=export.get("method"),
                               create_time=get_now_datetime(), update_time=get_now_datetime(), status=export.get("status"))
        db.add(db_export)
        db.commit()
        db.refresh(db_export)
    except Exception as e:
        print(e)
        return {}
    return db_export


def get_source_data(db):
    res = db.query(ExportFile.source).filter().group_by('source').all()
    return [i[0] for i in res]
