import json

import pymysql
from DBUtils.PooledDB import PooledDB


# 连接mysql
from core.config.env import env, red


class LinkMysql(object):
    def __init__(self, db_info):
        self.POOLMYSQL = PooledDB(
            creator=pymysql,
            maxconnections=6,
            mincached=2,
            blocking=True,
            ping=0,

            host=db_info.get("host"),
            port=db_info.get("port"),
            user=db_info.get("user"),
            password=db_info.get("pwd"),
            database=db_info.get("database"),
            charset='utf8'
        )

    # 查询
    def query_mysql(self, sql):
        conn = self.POOLMYSQL.connection()
        cursor = conn.cursor(cursor=pymysql.cursors.DictCursor)
        cursor.execute(sql)
        result = cursor.fetchall()
        cursor.close()
        conn.close()
        return result

    # 修改
    def perform_mysql(self, sql):
        conn = self.POOLMYSQL.connection()
        cursor = conn.cursor()
        cursor.execute(sql)
        last_id = cursor.lastrowid
        conn.commit()
        cursor.close()
        conn.close()
        return last_id

    # 执行
    def excete_mysql(self, sql):
        conn = self.POOLMYSQL.connection()
        cursor = conn.cursor(cursor=pymysql.cursors.DictCursor)
        cursor.execute(sql)


# class RabbitMqConn(object):
#     """rabbitmq 连接"""
#     def __init__(self):
#         rb = env.RABBITMQ
#         rb_info = pika.PlainCredentials(rb.get('username'), rb.get('password'))
#         self.connection = pika.BlockingConnection(parameters=pika.ConnectionParameters(rb.get('host'), rb.get('port'), rb.get('vhost'), rb_info))
#         self.channel = self.connection.channel()


from qcloud_cos import CosConfig
from qcloud_cos import CosS3Client
# 连接服务器
class LinkMonitor(object):

    def __init__(self):
        conn = CosConfig(Region=env.TX_REGION, SecretId=env.TX_SECRET_ID, SecretKey=env.TX_SECRET_KEY,
                         Token=None, Scheme='https')
        self.client = CosS3Client(conn)

    # 断点上传
    def upload_block(self, path, key, folder=""):

        # 正常情况日志级别使用INFO，需要定位时可以修改为DEBUG，此时SDK会打印和服务端的通信信息
        # logging.basicConfig(level=logging.INFO, stream=sys.stdout)

        token = None
        scheme = 'https'  # 指定使用 http/https 协议来访问 COS，默认为 https，可不填

        response = self.client.upload_file(
            Bucket=env.TX_BUCKET,
            Key=folder + key + '.xlsx',
            LocalFilePath=path,
            EnableMD5=False,
            progress_callback=None
        )
