import math
import threading
import time
from concurrent.futures.thread import ThreadPoolExecutor
from datetime import datetime

import openpyxl
import pandas as pd
from fastapi import Depends
from sqlalchemy import func, and_

from app import get_db
from app.api.statement import schemas
from app.api.statement.guild import query_token
from starlette.responses import StreamingResponse
from sqlalchemy.orm import Session
from app.api.export import crud
from core.config.env import env
from libs.db_link import LinkMysql
from core.config.env import env
from libs.db_link import LinkMysql
from libs.functions import time_str_to_timestamp, timestamp_to_time_str, get_month_last_month, get_date_list
from libs.orm import QueryAllData
from models.recharge import Recharge, UserWC, GuildWC, FinanceFixLog
from models.menuconfig import Menuconfig
from models.users import User

locka = threading.Lock()


# 写入文件
def data_to_file(db, data, name, header, field_list):
    # 获取操作人
    user = query_token(db, header)
    params = {"source": name, "method": "data_to_file", "status": 1}
    if len(data) == 0:
        params["status"] = 3
    try:
        bk = pd.DataFrame(data)
        if data[0].get('create_time'):
            if isinstance(data[0]['create_time'], int):
                bk['create_time'] = bk['create_time'].apply(
                    lambda x: time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(x)))
        bk.columns = field_list  # 修改pandas头
        with pd.ExcelWriter(f'static/{name}.xlsx') as writer:
            bk.to_excel(writer, sheet_name='Sheet1', index=False)
        file = open(writer, 'rb')
        # 记录导出
        crud.create_export_data(db, params, user)
        return StreamingResponse(file, media_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
    except Exception as e:
        params["status"] = 2
        crud.create_export_data(db, params, user)


class RechargeStatement(object):
    """充值报表"""

    def __init__(self):
        self.linkmysql = LinkMysql(env.DB_HISTORY)
        # self.count=[]
        # self.once_res=[]
        # self.moeny_data=[]

    def query_data(self, db, page, size, order_number, uuid, sid, start_time, end_time, type, menu_id, month_type):
        """列表"""
        query = []
        if order_number:
            query.append(f"reference_number='{order_number}'")
        if uuid:
            query.append(f"uuid='{uuid}'")
        if sid:
            query.append(f"sid='{sid}' ")
        if type:
            query.append(f"type='{type}' ")
        if menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        else:
            querydata = db.query(Menuconfig).filter(Menuconfig.menu_type == 1)  # 1是充值
            reference_data = [QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        if month_type == 1:
            if start_time:
                query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
            if end_time:
                query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(month_type,start_time)
            count, once_res, moeny_data = self.statistics_data(month_type, query, page, size, now_month[1])
        else:
            query_data = self.query_add_time(start_time, end_time, query)
            count, once_res, moeny_data = self.thread_data(month_type, query_data, page, size,start_time)
        return count, once_res, moeny_data

    def query_add_time(self, start_time, end_time, old_query):
        data = []
        query = []
        query1 = []
        query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        query1.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        query1.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if old_query:
            query = query + old_query
            query1 = query1 + old_query
        data.append(query)
        data.append(query1)
        return data

    def statistics_data(self, month_type, query, page, size, now_month):
        '''统计'''
        if month_type == 1:
            count_sql = f"SELECT count(*) FROM assets_log_{now_month}  where {query}"
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")
            sql = f"SELECT a.id,a.uuid,a.amount/1000 as amount,FROM_UNIXTIME(a.create_time) as payment_time,a.reference_type,a.reference_number FROM assets_log_{now_month} as a where  {query}  ORDER BY id desc limit {(int(page) - 1) * size},{size}"
            once_res = self.linkmysql.query_mysql(sql)
            money_sql = f"SELECT sum(amount) FROM assets_log_{now_month}  where {query}"
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") if \
                self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") != None else 0

        else:
            count_sql = "SELECT sum(a.b) FROM ("f"SELECT count(*) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query[0]))}  UNION ALL SELECT count(*) FROM assets_log_{int(now_month[1])}  where {(' and '.join(query[1]))}) AS a "
            count = self.linkmysql.query_mysql(count_sql)[0].get("sum(a.b)")
            query1 = (' and '.join(query[0]))
            query2 = (' and '.join(query[1]))
            sql = f"SELECT  id,uuid,amount/1000 as amount,FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[0])}  where {query1}  UNION ALL SELECT id,uuid,amount/1000 as amount,FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[1])}  where {query2}  ORDER BY payment_time desc limit {(int(page) - 1) * size},{size}"
            once_res = self.linkmysql.query_mysql(sql)
            money_sql = f"SELECT sum(a.b) FROM ("f"SELECT sum(amount) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query[0]))} UNION ALL SELECT sum(amount)FROM assets_log_{int(now_month[1])}  where {(' and '.join(query[1]))})  AS a "
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") if \
                self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") != None else 0
        return count, once_res, moeny_data/1000

    def thread_data(self, month_type, query, page, size,start_time):
        now_month = get_month_last_month(month_type,start_time)
        count, once_res, moeny_data = self.statistics_data(month_type, query, page, size, now_month)
        return count, once_res, moeny_data

    def get_statements(self, db, data):
        """导出"""
        query = []
        if data.order_number:
            query.append(f"id={data.order_number} ")
        if data.user_id:
            query.append(f"uuid='{data.user_id}' ")
        if data.sid:
            query.append(f"sid='{data.sid}' ")
        if data.menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(data.menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        if data.month_type == 1:
            if data.start_time:
                query.append(f" create_time >= {time_str_to_timestamp(data.start_time + ' 00:00:00')} ")
            if data.end_time:
                query.append(f" create_time < {time_str_to_timestamp(data.end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(data.month_type,data.start_time)
            once_res = self.data_delcy(data.month_type, query, now_month[1])
        else:
            query_data = self.query_add_time(data.start_time, data.end_time)
            now_month = get_month_last_month(data.month_type)
            once_res = self.data_delcy(data.month_type, query_data, now_month)
        return once_res

    def data_delcy(self, month_type, query, now_month):
        if month_type == 1:
            sql = f"SELECT a.uuid,a.amount,FROM_UNIXTIME(a.create_time,'%Y-%c-%d %h:%i:%s') as payment_time,a.reference_type,a.order_number FROM assets_log_{now_month} as a where  {query}"
            once_res = self.linkmysql.query_mysql(sql)
        else:
            query1 = (' and '.join(query[0]))
            query2 = (' and '.join(query[1]))
            sql = f"SELECT  id,uuid,amount,FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as payment_time,reference_type,order_number FROM assets_log_{int(now_month[0])}  where {query1} UNION ALL SELECT id,uuid,amount,FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as payment_time,reference_type,order_number FROM assets_log_{int(now_month[1])}  where {query2} "
            once_res = self.linkmysql.query_mysql(sql)
        return once_res


class WithdrawStatement(object):
    """提现报表"""

    def __init__(self):
        self.derive_user_list = []
        self.linkmysql = LinkMysql(env.DB_HISTORY)
        self.derive_guild_list = []

    def thread_to_data(self, db, num):
        user_list = []
        locka.acquire()
        once_res = db.query(UserWC).filter().offset(num * 10).limit(10).all()
        locka.release()
        for i in once_res:
            info_dict = i.to_dict()
            user_list.append(info_dict)
        self.derive_user_list += user_list

    def query_add_time(self, start_time, end_time):
        data = []
        query = []
        query1 = []
        query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        query.append(f" create_time < {time_str_to_timestamp(start_time + ' 23:59:59')} ")
        query1.append(f" create_time >= {time_str_to_timestamp(end_time + ' 00:00:00')} ")
        query1.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        data.append(query)
        data.append(query1)
        return data

    def get_user_withdraw_cash(self, db, page, size, uuid, status, start_time, end_time, month_type, menu_id):
        query = []
        if uuid:
            query.append(f" uuid='{uuid}'")
        if status:
            query.append(f"status={status} ")
        if menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        else:
            querydata = db.query(Menuconfig).filter(Menuconfig.menu_type == 3)  # 3是用户提现
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        if month_type == 1:
            if start_time:
                query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
            if end_time:
                query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(month_type,start_time)
            count, once_res, moeny_data = self.dispose_user(month_type, query, page, size, now_month[1])
        else:
            query_data = self.query_add_time(start_time, end_time)
            now_month = get_month_last_month(month_type,start_time)
            count, once_res, moeny_data = self.dispose_user(month_type, query_data, page, size, now_month)
        return count, once_res, moeny_data

    def dispose_user(self, month_type, query, page, size, now_month):
        if month_type == 1:
            count_sql = f"SELECT count(*) FROM assets_log_{now_month}  where {query}"
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")
            sql = f'SELECT uuid,a.reference_type,a.reference_number,FROM_UNIXTIME(a.create_time,"%Y-%c-%d %h:%i:%s") as payment_time,a.amount_type FROM assets_log_{now_month} as a where {query} ORDER BY id desc limit {(int(page) - 1) * size},{size}'
            once_res = self.linkmysql.query_mysql(sql)
            money_sql = f"SELECT sum(amount) FROM assets_log_{now_month}  where {query} "
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") if \
                self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") != None else 0
        else:
            count_sql = "SELECT sum(a.b) FROM ("f"SELECT count(*) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query[0]))}  UNION ALL SELECT count(*) FROM assets_log_{int(now_month[1])}  where {(' and '.join(query[1]))})  AS a "
            count = self.linkmysql.query_mysql(count_sql)[0].get("sum(a.b)")
            query1 = (' and '.join(query[0]))
            query2 = (' and '.join(query[1]))
            sql = f"SELECT  id,uuid,amount,amount_type, FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[0])}  where {query1}  UNION ALL SELECT id,uuid,amount,FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as payment_time,reference_type,reference_number,amount_type FROM assets_log_{int(now_month[1])}  where {query2}   ORDER BY id desc limit {(int(page) - 1) * size},{size}"
            print(sql)
            once_res = self.linkmysql.query_mysql(sql)
            money_sql = f"SELECT sum(a.b) FROM ("f"SELECT sum(amount) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query[0]))}   UNION ALL SELECT sum(amount)FROM assets_log_{int(now_month[1])}  where {(' and '.join(query[1]))}  ) AS a "
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") if \
                self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") != None else 0
        return count, once_res, moeny_data

    def get_guild_withdraw_cash(self, db, page, size, name, status, start_time, end_time, month_type, menu_id):
        """公会提现"""
        query = []
        if name:
            query.append(f" nickname like '%{name}%' ")
        if status:
            query.append(f"status={status} ")
        if menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        else:
            querydata = db.query(Menuconfig).filter(Menuconfig.menu_type == 4)  # 4是公会提现
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        if month_type == 1:
            if start_time:
                query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
            if end_time:
                query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(month_type,start_time)
            count, once_res, moeny_data = self.dispose_user(month_type, query, page, size, now_month[1])
        else:
            query_data = self.query_add_time(start_time, end_time)
            now_month = get_month_last_month(month_type,start_time)
            count, once_res, moeny_data = self.dispose_user(month_type, query_data, page, size, now_month)
        return count, once_res, moeny_data


class FinanceFix(object):

    @staticmethod
    def get_finance_fix_data(page, size, start_time, end_time):
        """财务修复"""
        finance_filters = []
        if start_time:
            finance_filters.append(f" create_time <= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        if end_time:
            finance_filters.append(f" create_time <= {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if finance_filters:
            count_sql = f"select count(id) as num from finance_fix_log where {' and '.join(finance_filters)}"
            data_sql = f"select id,type,money,unique_tag,amount_type,operator,create_time,remark from finance_fix_log where {' and '.join(finance_filters)} order by id DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select count(id) as num from finance_fix_log"
            data_sql = f"select id,type,money,unique_tag,amount_type,operator,create_time,remark from finance_fix_log order by id DESC limit {(int(page) - 1) * size},{size}"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, count_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, data_sql)
        total = future1.result()
        res = future2.result()
        if res:
            result = []
            for i in res:
                if i['type'] != 0:
                    i['name'] = i['unique_tag']
                i['create_time'] = timestamp_to_time_str(i['create_time'])
                i['money'] = float(i['money'])
                result.append(i)
            return result, total[0]['num']
        return [], 0


def create_menu(db: Session, menu: schemas.MenuAdd):
    try:
        db_menu = Menuconfig(menu_name=menu.menu_name, menu_label=menu.menu_label, menu_type=menu.menu_type,
                             create_time=datetime.now(), remark=menu.remark if menu.remark != '' else '')
        db.add(db_menu)
        db.commit()
        db.refresh(db_menu)
    except Exception as e:
        print(e)
        return {}
    return db_menu


def get_menu_name(db: Session, menu_name: str):
    return db.query(Menuconfig).filter(Menuconfig.menu_name == menu_name).first()


def get_menu_id(db: Session, id: str):
    return db.query(Menuconfig).filter(Menuconfig.id == id).first()


def get_menu_update(db: Session, data):
    query_data = db.query(Menuconfig).filter(Menuconfig.id == data.id).update({Menuconfig.menu_name: data.menu_name,
                                                                               Menuconfig.menu_label: data.menu_label,
                                                                               Menuconfig.menu_type: data.menu_type,
                                                                               Menuconfig.remark: data.remark,
                                                                               Menuconfig.create_time: datetime.now()
                                                                               })
    db.commit()
    return query_data


def get_menu_delete(db: Session, id):
    query_data = db.query(Menuconfig).filter(Menuconfig.id == id).delete()
    db.commit()
    return query_data


def get_menu_list(db: Session, page, size, menu_name, menu_label, menu_type):
    querys = []
    if menu_name:
        querys.append(Menuconfig.menu_name.like(f'%{menu_name}%'))
    if menu_label:
        querys.append(Menuconfig.menu_label == menu_label)
    if menu_type:
        querys.append(Menuconfig.menu_type == menu_type)
    if querys:
        querydata = db.query(Menuconfig).filter(*querys).order_by(
            Menuconfig.id.desc()).offset((int(page) - 1) * size).limit(size)
        data = [QueryAllData.serialization(item) for item in querydata]
    else:
        querydata = db.query(Menuconfig).filter().order_by(
            Menuconfig.id.desc()).offset((int(page) - 1) * size).limit(size)
        data = [QueryAllData.serialization(item) for item in querydata]
    count = db.query(func.count(Menuconfig.id)).filter().scalar()
    return data, count


def get_menu_config(db: Session, menu_type):
    querys = []
    if menu_type:
        querys.append(Menuconfig.menu_type == menu_type)
    querydata = db.query(Menuconfig).filter(*querys).order_by(
        Menuconfig.id.desc())
    data = [QueryAllData.serialization(item, remove={'create_time', 'remark'}) for item in querydata]
    return data
