from sqlalchemy.orm import Session
from libs.orm import QueryAllData
from models.margin import GuildMargin


def get_margin(db: Session, param):
    """保证金列表，查询"""
    guild_filters = []
    if param.get("guild_id"):
        guild_filters.append(GuildMargin.guild_id == param.get("guild_id"))
    if param.get("status"):
        guild_filters.append(GuildMargin.status == param.get("status"))
    if param.get("start_time"):
        guild_filters.append(GuildMargin.create_time >= param.get("start_time") + " 00:00:00")
    if param.get("end_time"):
        guild_filters.append(GuildMargin.create_time <= param.get("end_time") + " 23:59:59")
    querydata, count = QueryAllData(db, GuildMargin, param, guild_filters).query_data()
    data = [QueryAllData.serialization(item) for item in querydata]
    return data, count
