import datetime
from sqlalchemy import and_, func

_privacy_fields = {''}


class QueryAllData:

    def __init__(self, db, dbname, params, params_list):
        '''
        初始化参数
        '''
        self.db = db
        self.dbname = dbname
        self.page = params.get("page", 1)
        self.limit = params.get("size", 10)
        self.params = params
        self.params_list = params_list

    def query_data(self):
        '''
        查询所有
        '''
        if self.params == {}:
            queryData = self.db.query(self.dbname).filter().order_by(self.dbname.id.desc()).all()
            count = self.db.query(func.count(self.dbname.id)).scalar()
        elif self.params_list == None:
            queryData = self.db.query(self.dbname).filter().order_by(self.dbname.id.desc()).offset(
                (int(self.page) - 1) * self.limit).limit(self.limit).all()
            count = self.db.query(func.count(self.dbname.id)).scalar()
        else:
            queryData = self.db.query(self.dbname).filter(and_(*self.params_list)).order_by(
                self.dbname.id.desc()).offset((int(self.page) - 1) * self.limit).limit(self.limit).all()
            count = self.db.query(func.count(self.dbname.id)).filter(and_(*self.params_list)).scalar()
        return queryData, count

    def query_filter(self):
        '''
        单个查询
        '''
        pass

    def set_attrs(self, attrs_dict):
        """批量更新模型的字段数据
        """
        for key, value in attrs_dict.items():
            setattr(self, key, value)
        return self

    def serialization(self, funcs: list = None, remove: set = None, increase: set = None) -> dict:
        """序列化指定字段
        :return: dict({'field_name': field_value})
        """
        if funcs is None:
            funcs = list()
        if remove is None:
            remove = set()
        if increase is None:
            increase = set()
        result = dict()
        fields = set(name.name for name in self.__table__._columns)
        fields = fields - remove  # 需要被隐藏的字段
        fields = fields | increase  # 取消被隐藏的字段
        for column in fields:
            value = getattr(self, column)
            if isinstance(value, datetime.datetime):
                value = value.strftime('%Y-%m-%d %H:%M:%S')
            result[column] = value
        if funcs:
            for func in funcs:
                func, args, kwargs = func
                getattr(self, func)(result, *args, **kwargs)
        return result
