from wtforms import StringField, IntegerField,BooleanField
from wtforms.validators import DataRequired

from src.libs.validaters import BaseForm, RequestBaseForm


class  RoomAddFrom(RequestBaseForm):
      """
      房间新增信
      """
      name = StringField(validators=[DataRequired(message='房间不能为空')])
      empty_timeout = IntegerField()
      max_participants = IntegerField()
      metadatas = StringField()
      user_ids=StringField()
      create_user=StringField(validators=[DataRequired(message='创建者不能为空')])
      room_create = BooleanField()
      room_list = BooleanField()
      room_admin=BooleanField()
      node_id=IntegerField()

      def validate_name(self,val):
            if val.data:
                  self.name.data=val.data


      def validate_room_list(self,val):
            if val.data==None:
                  self.room_list.data=False

      def validate_room_admin(self,val):
            if val.data==None:
                  self.room_admin.data=False




class  RoomListFrom(BaseForm):
       names=StringField(validators=[DataRequired(message='房间名字不能为空')])


class RoomDeleteFrom(BaseForm):
      names = StringField(validators=[DataRequired(message='房间名字不能为空')])
      token = StringField(validators=[DataRequired(message='token不能为空')])


class RoomCreateTokenFrom(BaseForm):
      name = StringField(validators=[DataRequired(message='房间不能为空')])


# class UserStatStopIdForm(BaseForm):
#     """用户账户启用停用"""
#     id = IntegerField(validators=[DataRequired(message='主id不能为空')])
#     stop = IntegerField(Optional)
#
#     def validate_id(self, val):
#         stop = 0
#         if self.stop.data:
#             stop = self.stop.data
#         if val.data:
#             user_info = Users.query.filter(Users.id == val.data, Users.status == 0).first()
#             if user_info:
#                 user_info.set_attrs({"stop": stop}).direct_update_()
#             else:
#                 raise APIException(code=500, message="未查到用户")
#
#
# class SignInForm(BaseForm):
#     username = StringField(validators=[DataRequired(message='账户不能为空')])
#     password = StringField(validators=[DataRequired(message='密码不能为空')])
#     stop = IntegerField(Optional)
#     user_infos = StringField(Optional)
#
#     def validate_username(self, val):
#         user_info = Users.query.filter(Users.username == val.data).first()
#         if not user_info:
#             raise APIException(code=404, message="未查到用户")
#         if user_info.stop == 1:
#             raise APIException(code=403, message="账户已停用")
#         if check_password(user_info.password_hash, self.password.data) == False:
#             raise APIException(code=400, message="账户密码错误")
#         if user_info:
#             user_info.set_attrs({"label": 0}).direct_update_()
#         self.user_infos.data = user_info
#
#
# class UserDeleteForm(BaseForm):
#     """用户删除"""
#     id = IntegerField(Optional)
#
#     def validate_id(self, val):
#         task_info = Task.query.filter(Task.user_id == g.user.id, Task.run_status == 1).first()
#         if task_info:
#             raise ValidationError(message='有任务进行,无法删除用户')
#         else:
#             user_info = Users.query.filter(Users.id == g.user.id).first()
#             if user_info:
#                 user_info.delete().direct_update_()
