"""这里用户标签权限认证"""
from flask import g
import functools

from src.libs.error import APIException


def permission(auth_level=None):
    def wrapper(func):
        @functools.wraps(func)
        def inner(*args, **kwargs):
            user_label = g.user.label
            if user_label:
                if user_label not in auth_level:
                    raise APIException(error_code=1004, message='权限不够， 请联系管理员')
            return func(*args, **kwargs)

        return inner

    return wrapper
