import datetime
from sqlalchemy import TIMESTAMP, SmallInteger
from src.app.orm import Common, db


class FriendTimeline(Common, db.Model):
    """朋友圈时间轴表"""
    __tablename__ = 'missu_friend_timeline'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    uid = db.Column(db.BIGINT, comment="用户id")
    fcmid = db.Column(db.Integer, comment="朋友圈信息id")
    is_own = db.Column(db.Integer, comment="是否是自己的  0是1不是")
    create_time = db.Column(TIMESTAMP, default=datetime.datetime.now(), comment="创建时间")


# missu_roster 好友表
# missu_users 用户表
# missu_users_binary 相册表


class FriendMessage(Common, db.Model):
    """
    发布朋友圈
    """
    __tablename__ = 'missu_friend_message'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    uid = db.Column(db.BIGINT, comment="用户id")
    res_type = db.Column(db.Integer, comment="0 图片， 1 视频 2文字")
    content = db.Column(db.String(500), comment="内容文字")
    file_name = db.Column(db.String(500), comment="文件地址")
    location = db.Column(db.String(100), comment="ip位置")
    create_time = db.Column(TIMESTAMP, default=datetime.datetime.now(), comment="创建时间")
    status = db.Column(SmallInteger, default=2)
    audit_status = db.Column(db.Integer, default=0, comment="0是未审核，1.是审核中。2.是审核成功。3.审核失败")
    watch_uid = db.Column(db.String(500), comment="权限uid用户id")


class FriendComment(Common, db.Model):
    """评论表"""
    __tablename__ = 'missu_friend_comment'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    fcmid = db.Column(db.BIGINT, comment="朋友圈信息id")
    review_to = db.Column(db.BIGINT, comment="回复对象id")
    uid = db.Column(db.BIGINT, comment="评论者id")
    content = db.Column(db.String(500), comment="内容")
    create_time = db.Column(TIMESTAMP, default=datetime.datetime.now(), comment="创建时间")
    status = db.Column(SmallInteger, default=2)
    like_count = db.Column(db.Integer, comment="点赞数")
    is_look = db.Column(db.Integer, default=0, comment="0未查看，1已查看")


class FriendGive(Common, db.Model):
    __tablename__ = 'missu_friend_give'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    fcmid = db.Column(db.BIGINT, comment="朋友圈信息id")
    uid = db.Column(db.BIGINT, comment="用户id")
    like_count = db.Column(db.Integer, comment="点赞数")
    is_look = db.Column(db.Integer, default=0, comment="0未查看，1已查看")


class FriendMoments(Common, db.Model):
    '''
    图片修改
    '''
    __tablename__ = 'missu_friend_moments'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    uid = db.Column(db.BIGINT, comment="用户id")
    image_path = db.Column(db.String(500), comment="图片地址")
