import datetime

from sqlalchemy import TIMESTAMP, Integer, BIGINT, String, Text

from src.app.orm import Common, db


class Examineline(Common, db.Model):
    """审核表"""
    __tablename__ = 'missu_examine_line'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    content_old = db.Column(db.Text, comment="原内容")
    content_new = db.Column(db.Text, comment="新内容")
    create_time = db.Column(TIMESTAMP, default=datetime.datetime.now(), comment="提交时间")
    type = db.Column(db.Integer, comment="1是昵称2头像地址3.个签4.手机号")
    # 0是未审核，1.是审核中。2.是审核成功。3.审核失败
    examine_people = db.Column(db.String(100), comment="审核人")
    examine_time = db.Column(TIMESTAMP, comment="审核时间")


class Examinecontent(Common, db.Model):
    """审核朋友圈记录表"""
    __tablename__ = 'missu_examine_content'
    id = db.Column(Integer, primary_key=True, autoincrement=True)
    fcmid = db.Column(Integer, comment="朋友圈信息id")
    uid = db.Column(BIGINT, comment="用户id")
    content = db.Column(db.Text, comment="内容")
    create_time = db.Column(TIMESTAMP, default=datetime.datetime.now(), comment="提交时间")
    res_type = db.Column(Integer, comment="0 图片， 1 视频 2文字")
    examine_people = db.Column(String(225), comment="审核人")
    file_name = db.Column(String(225), comment="文件地址")
    examine_time = db.Column(TIMESTAMP, comment="审核时间")
    audit_status = db.Column(Integer, default=0, comment="0是未审核，1.是审核中。2.是审核成功。3.审核失败")
    status = db.Column(Integer, default=0, comment="")


class Examinecomment(Common, db.Model):
    """朋友圈评论记录表"""
    __tablename__ = 'missu_comment_content'
    id = db.Column(Integer, primary_key=True, autoincrement=True)
    uid = db.Column(BIGINT, comment="用户id")
    content = db.Column(Text, comment="评论内容")
    create_time = db.Column(TIMESTAMP, default=datetime.datetime.now(), comment="提交时间")
    examine_people = db.Column(String(225), comment="审核人")
    examine_time = db.Column(TIMESTAMP, comment="审核时间")
    audit_status = db.Column(Integer, default=0, comment="0是未审核，1.是审核中。2.是审核成功。3.审核失败")
    failed_reason = db.Column(String(225), comment="驳回原因")
    status = db.Column(Integer, default=0, comment="")
