import datetime

from sqlalchemy import Column, SMALLINT, TIMESTAMP

from src.app.orm import Common, db


class Room(Common, db.Model):
    """房间的基本信息"""
    __tablename__ = 'room'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    name = db.Column(db.String(255), comment="房间名字")
    empty_timeout = db.Column(db.Integer, comment="过期时间(秒)")
    max_participants = db.Column(db.Integer, comment="限制房间内的参与者人数")
    metadatas = db.Column(db.String(500), comment="原数据存储")
    create_user = db.Column(db.String(100), comment="创建者")
    create_time = db.Column(TIMESTAMP, default=datetime.datetime.now, comment="创建者")
    node_id = db.Column(db.String(320), comment="节点编号")


class RoomLogo(Common, db.Model):
    """请求日志拦截"""
    __tablename__ = 'room_log'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    username = db.Column(db.String(11), comment="用户名")
    login_ip = db.Column(db.String(50), comment="登录ip")
    create_by = db.Column(db.String(64), comment="创建者")
    email = db.Column(db.String(320))
    remark = db.Column(db.Text, comment="备注")
    password_hash = db.Column(db.String(150))
    stop = Column(SMALLINT, default=0, comment='当前账号默认情况，0为正常,1为停用')
    label = Column(db.Integer, default=1, comment="标签0为administrator,1为none无权限,2为work权限有任务管理和日志管理。3为supervisor的日志管理")
