import logging
import os

import yaml
from pydantic import BaseSettings
from qcloud_cos import CosConfig, CosS3Client

SECRET_KEY = 'temp'
LOG_LEVEL = logging.DEBUG
LOG_STDERR = False  # 输出到标准错误流
SITE_ROOT = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
LOG_PATH = os.path.join(SITE_ROOT, "bin", "runtime", "logs", "")
CONFIG_YAML = os.path.join(SITE_ROOT, "bin", "runtime", "yaml", "config.yaml")
APPLLO_YAML = os.path.join(SITE_ROOT, "bin", "runtime", "yaml", "apollo.yaml")
apollo = yaml.safe_load(open(CONFIG_YAML, encoding='utf-8'))
# 获取配置
SQLALCHEMY_CONFIG = apollo.get("SQLALCHEMY_CONFIG")
SQLALCHEMY_DATABASE_URI = [item.get("DATABASE_URI") for item in SQLALCHEMY_CONFIG][0]
SQLALCHEMY_TRACK_MODIFICATIONS = [item.get("SQLALCHEMY_TRACK_MODIFICATIONS") for item in SQLALCHEMY_CONFIG][1]
SDK_CONFIG = apollo.get("SDK_CONFIG")
SDK_CONFIG_APPID = [item.get("APPID") for item in SDK_CONFIG][0]
SDK_CONFIG_APPSECRET = [item.get("APPSECRET") for item in SDK_CONFIG][1]
SDK_CONFIG_IDENTITY = [item.get("IDENTITY") for item in SDK_CONFIG][2]
SDK_CONFIG_NAME = [item.get("NAME") for item in SDK_CONFIG][3]
UPLOAD_FOLDER = os.path.join(SITE_ROOT, "bin", "runtime", "files", "")
COS_FOLDER = os.path.join(SITE_ROOT, "bin", "runtime", "cos_files")
COS_CONFIG = apollo.get("COS_CONFIG")
Region = [item.get("Region") for item in COS_CONFIG][0]
SecretId = [item.get("SecretId") for item in COS_CONFIG][1]
SecretKey = [item.get("SecretKey") for item in COS_CONFIG][2]
Token = [item.get("Token") for item in COS_CONFIG][3]
scheme = [item.get("Scheme") for item in COS_CONFIG][4]
Bucket = [item.get("Bucket") for item in COS_CONFIG][5]
config = CosConfig(Region=Region, SecretId=SecretId, SecretKey=SecretKey, Token=Token, Scheme=scheme)
client = CosS3Client(config)


# business BUSINESS

class TestEnv(BaseSettings):
    DEBUG: bool = True
    TESTING: bool = False
    DATABASE_URI: str = 'sqlite://:memory:'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''
    BUSINESS: dict = {
        "database": "rainbowchat_pro",
        "host": "106.55.103.148",
        "port": 3398,
        "pwd": "iBNcMcnFhJhezYJB",
        "user": "root"
    }
    JAVA_PATH = "https://chat.pro.zhubei.cn/rainbowchat_pro_test"


class Env(BaseSettings):
    DEBUG: bool = True
    TESTING: bool = False
    DATABASE_URI: str = 'sqlite://:memory:'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''
    BUSINESS: dict = {
        "database": "rainbowchat_pro",
        "host": "122.9.167.192",
        "port": 4999,
        "pwd": "MK44tZZy2pzwbend",
        "user": "rainbowchat_pro"
    }
    JAVA_PATH = "https://chat.pro.zhubei.cn/rainbowchat_pro"


env = TestEnv()
# env = Env()
