from wtforms import StringField, IntegerField
from wtforms.validators import DataRequired
from configs.config import env
from src.libs.db_link import LinkMysql
from src.libs.error import APIException
from src.libs.validaters import RequestBaseForm, BaseForm
from src.modules.friend import FriendMessage, FriendComment, FriendGive


class FriendSendAddFrom(RequestBaseForm):
    """
    朋友圈发送内容
    """
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    content = StringField()
    res_type = IntegerField()
    file_name = StringField()
    location = StringField()
    watch_uid = StringField()

    def validate_uid(self, val):
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')

    def validate_content(self, val):
        if val.data:
            self.content.data = val.data

    def validate_file_name(self, val):
        if val.data:
            if len(val.data) >= 9:
                raise APIException(code=500, message='超出数量,无法保存')


class FriendsListFrom(BaseForm):
    '''
    朋友圈列表
    '''
    uid = StringField(validators=[DataRequired(message="uid不能为空")])

    def validate_uid(self, val):
        self.params = []
        if val.data:
            sql = f"SELECT * FROM `missu_roster`  where user_uid='{val.data}'"
            friends_list = LinkMysql(env.BUSINESS).query_mysql(sql)
            if friends_list == ():
                raise APIException(code=500, message='用户未查询到')
            uuid_list = [item.get("friend_user_uid") for item in friends_list]
            uuid_list.append(int(val.data))
            uuids = tuple(uuid_list)
            self.params.append(FriendMessage.uid.in_(uuids))


class FriendCommentAddFrom(BaseForm):
    """
          朋友圈发送内容
          """
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    fcmid = StringField(validators=[DataRequired(message="内容id不能为空")])
    content = StringField()
    review_to = IntegerField()

    def validate_uid(self, val):
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')


class FriendCommentDeleteFrom(BaseForm):
    """
    删除评论
    """
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    fcmid = StringField(validators=[DataRequired(message="内容id不能为空")])
    commentid = StringField(validators=[DataRequired(message="评论id不能为空")])

    def validate_uid(self, val):
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')

    def validate_fcmid(self, val):
        if val.data:
            friend_info = FriendComment.query.filter(FriendComment.fcmid == val.data,
                                                     FriendComment.uid == self.uid.data,
                                                     FriendComment.id == self.commentid.data).first()
            if friend_info and friend_info.status != 1:
                friend_info.set_attrs({'status': 1}).direct_update_()
                friend_info = FriendComment.query.filter(FriendComment.fcmid == val.data,
                                                         FriendComment.uid == self.uid.data,
                                                         FriendComment.review_to == self.commentid.data).all()
                for item in friend_info:
                    item.set_attrs({'status': 1}).direct_update_()


class FriendGivetAddFrom(BaseForm):
    """
    朋友圈信息点赞
    """
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    fcmid = StringField(validators=[DataRequired(message="朋友圈信息id")])
    like_count = IntegerField()

    def validate_uid(self, val):
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')


class FriendGivetDeleteFrom(BaseForm):
    """
          删除评论
          """
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    fcmid = StringField(validators=[DataRequired(message="朋友圈信息id")])
    type = IntegerField()

    def validate_uid(self, val):
        friend_info = FriendGive.query.filter(FriendGive.fcmid == self.fcmid.data, FriendGive.uid == self.uid.data,
                                              FriendGive.status == 0).first()
        if friend_info:
            friend_info.set_attrs({'status': 1}).direct_update_()


class FriendBackgroundFrom(BaseForm):
    '''
    朋友圈背景修改
    '''
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    images = StringField(validators=[DataRequired(message="图片名地址不能为空")])

    def validate_uid(self, val):
        friend_info = FriendGive.query.filter(FriendGive.uid == self.uid.data,
                                              FriendGive.status == 0).first()
        if friend_info:
            friend_info.set_attrs({'image_path': self.images.data}).direct_update_()


class FriendsCommentListFrom(BaseForm):
    '''
    评论列表
    '''
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    fcmid = StringField(validators=[DataRequired(message="朋友圈信息id不能为空")])
    myUid = StringField(validators=[DataRequired(message="访问者id不能为空")])

    def validate_uid(self, val):
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')


class GiveCommentListFrom(BaseForm):
    '''
    点赞
    '''
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    fcmid = StringField(validators=[DataRequired(message="朋友圈信息id不能为空")])

    def validate_uid(self, val):
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')


class CircleListFrom(BaseForm):
    '''
    获取朋友圈详情
    '''
    uid = StringField(validators=[DataRequired(message="uid不能为空")])

    def validate_uid(self, val):
        self.params = []
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')
            self.params.append(FriendMessage.uid == self.uid.data)
            self.params.append(FriendMessage.status == 0)


class ContentListFrom(BaseForm):
    '''
    内容
    '''
    uid = StringField(validators=[DataRequired(message="uid不能为空")])
    fcmid = StringField(validators=[DataRequired(message="朋友圈信息id不能为空")])

    def validate_uid(self, val):
        self.params = []
        if val.data:
            sql = f"SELECT * FROM `missu_users`  where user_uid='{val.data}'"
            user_info = LinkMysql(env.BUSINESS).query_mysql(sql)
            if user_info == ():
                raise APIException(code=500, message='用户未查询到')
            self.params.append(FriendMessage.uid == self.uid.data)

    def validate_fcmid(self, val):
        if val.data:
            friend_info = FriendMessage.query.filter(FriendMessage.id == val.data,
                                                     FriendMessage.uid == self.uid.data).first()
            friend_info.set_attrs({'status': 1}).direct_update_()
