import datetime
import os, redis
from concurrent.futures import ThreadPoolExecutor, ProcessPoolExecutor
from datetime import timedelta
from flask import Flask

from configs.config import SQLALCHEMY_DATABASE_URI
from src.app.orm import db


def register_blueprint(app):
    """注册蓝图"""
    from src.app.api import __all__  as all_api
    for api in all_api:
        app.register_blueprint(api)


def create_app():
    app = Flask(__name__)
    # 从模块里面加载配置文件
    register_blueprint(app)
    app.config['SESSION_COOKIE_SAMESITE'] = "None"  # 设置samesite 为None
    app.config['SESSION_COOKIE_SECURE'] = True  # SECURE 为 true
    app.config['SQLALCHEMY_DATABASE_URI'] = SQLALCHEMY_DATABASE_URI
    app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False
    app.config['WTF_CSRF_ENABLED'] = False
    app.config['LOGIN_DISABLED'] = True
    app.config['SECRET_KEY'] = os.urandom(24)
    app.config['SQLALCHEMY_POOL_RECYCLE']=8
    app.config['PERMANENT_SESSION_LIFETIME'] = timedelta(hours=5)
    app.config['SCHEDULER_API_ENABLED'] = True
    # 线程池配置
    app.config['SCHEDULER_EXECUTORS'] = {
        'default': ThreadPoolExecutor(10),  # 默认线程数
        'processpool': ProcessPoolExecutor(5)  # 默认进程
    }
    db.init_app(app)
    with app.app_context():
        db.create_all(app=app)
    return app



