import json
from flask import request
from flask_cors import CORS
from src.app import create_app
from src.libs.log_utils import create_time_today
# from src.modules.room import RoomLogo

app = create_app()
CORS(app, resources=r'/*')
data = {}


@app.before_request
def process_request():
    re_time = create_time_today().strftime('%Y-%m-%d %H:%M:%S')  # 请求时间（北京）
    ip = request.remote_addr
    re_method = request.method
    re_content = request.values.to_dict()
    if re_content:
        re_content = json.dumps(re_content)
    else:
        re_content = None
    data = {
        're_time': re_time,  # 请求时间
        're_url': request.path,  # 请求url
        're_method': re_method,  # 请求方法
        're_ip': ip,  # 请求IP
        're_content': re_content,  # 请求参数
        're_user': "worker",  # 用户
        'type': 1
    }
    # RoomLogo().set_attrs(data).direct_commit_()




if __name__ == '__main__':
    from werkzeug.serving import run_simple
    APP_PORT = 5800
    run_simple(hostname="0.0.0.0", port=APP_PORT, application=app, use_reloader=True, use_debugger=True,
               use_evalex=True,
               threaded=True)
