# encoding=utf-8
import os
from werkzeug.utils import secure_filename
from flask import request
from src.app.api.friends.data_delte import FriendMessageNotice, save_friends, get_infoname, save_comment, \
    CircleOfFriends
from src.app.api.friends.validaters import FriendSendAddFrom, FriendsListFrom, FriendCommentAddFrom, \
    FriendCommentDeleteFrom, FriendGivetAddFrom, FriendGivetDeleteFrom, FriendBackgroundFrom, FriendsCommentListFrom, \
    CircleListFrom, ContentListFrom, GiveCommentListFrom
from src.app.api.friends import api
from src.libs.functions import result_format, paginate_info, upload_file, children_comment, list_give
from src.modules.friend import FriendMessage, FriendComment, FriendGive


@api.route('/send', methods=['POST'])
def friends_add():
    """朋友圈发送消息  视频文件存储到我的相册"""
    form = FriendSendAddFrom().validate_()
    fcmdata = save_friends(form.data)
    if not fcmdata:
        return result_format(code=500, message='发布失败')
    return result_format(code=200, message='发布成功', id=fcmdata)


@api.route('/circle/list', methods=['GET'])
def friends_list():
    """
    朋友圈列表
    """
    form = FriendsListFrom(request.args).validate_()
    page = request.args.get('page', default=1, type=int)
    limit = request.args.get('size', default=10, type=int)
    query_user = FriendMessage.query.filter().order_by(FriendMessage.id.desc())
    if form.params:
        query_user = query_user.filter(*form.params)
    paginate = query_user.paginate(page=page, per_page=limit, error_out=True)
    data = [item.serialization(increase={'create_time', 'uid', 'status'}) for item in paginate.items]
    datas = get_infoname(data)
    items = paginate_info(paginate=paginate)
    return result_format(code=200, data=datas, **items, message="查询成功")


@api.route('/circle/comment', methods=['POST'])
def friends_comment():
    """
    朋友圈评论
    """
    form = FriendCommentAddFrom().validate_()
    fcmdata = save_comment(form.data)
    FriendMessageNotice(form.fcmid.data, fcmdata, form.uid.data).query_praise_comment()
    return result_format(code=200, id=fcmdata.id, message='评论成功')


@api.route('/circle/comment/delete', methods=['GET'])
def friends_comment_delete():
    """
    删除评论
    """
    FriendCommentDeleteFrom(request.args).validate_()
    return result_format(code=200, message='评论成功')


@api.route('/circle/give', methods=['POST'])
def friends_give():
    """
    朋友圈信息点赞
    """
    form = FriendGivetAddFrom().validate_()
    friend_info = FriendGive.query.order_by(FriendGive.id.desc()).filter(FriendGive.fcmid == form.fcmid.data,
                                                                         FriendGive.uid == form.uid.data,
                                                                         ).first()
    if friend_info:
        if friend_info.status == 1:
            friend_info.set_attrs({'status': 0}).direct_update_()
        else:
            friend_info.set_attrs({'status': 1}).direct_update_()
            FriendMessageNotice(form.fcmid.data, friend_info, form.uid.data).query_praise_comment()
    else:
        res_data = FriendGive().set_attrs(form.data).direct_commit_()
        FriendMessageNotice(form.fcmid.data, res_data, form.uid.data).query_praise_comment()
    return result_format(code=200, message='操作成功')


@api.route('/basics/info', methods=['GET'])
def circle_of_friends():
    """朋友圈信息"""
    fcmid = request.args.get('fcmid', type=int)
    res_data = CircleOfFriends().query_info(fcmid)
    return result_format(code=200, data=res_data, message="查询成功")


@api.route('/circle/delete', methods=['POST'])
def friends_circle_delete():
    """
    删出发文内容
    """
    form = FriendGivetDeleteFrom().validate_()
    FriendGive().set_attrs(form.data).direct_commit_()
    return result_format(code=200, message='删除成功')


@api.route('/circle/background', methods=['POST'])
def friends_ground_edit():
    """朋友圈背景图修改"""
    FriendBackgroundFrom().validate_()
    return result_format(code=200, message='操作成功')


@api.route('/trends/list', methods=['GET'])
def trends_list():
    """
    动态列表
    """
    page = request.args.get('page', default=1, type=int)
    limit = request.args.get('size', default=10, type=int)
    query_user = FriendMessage.query.filter().order_by(FriendMessage.id.desc())
    paginate = query_user.paginate(page=page, per_page=limit, error_out=True)
    data = [item.serialization(increase={'create_time', 'uid', 'status'}, ) for item in paginate.items]
    datas = get_infoname(data)
    items = paginate_info(paginate=paginate)
    return result_format(code=200, data=datas, **items, message="查询成功")


@api.route('/circle/upload', methods=['POST'])
def circle_upload():
    """
    图片视频上传到oss
    """
    file = request.files['file']
    # filename, suffix = file.filename.split('.')  # 获取上传文件的文件名
    file_strem = file.read()
    filename_path = upload_file(file_strem, file.filename)
    return result_format(code=200, data=filename_path, **{"message": "上传成功"})


@api.route('/comment/list', methods=['GET'])
def circle_comment():
    """
    评论列表
    """
    form = FriendsCommentListFrom(request.args).validate_()
    data = children_comment(form.fcmid.data, form.myUid.data)
    return result_format(code=200, data=data, message="操作成功")


@api.route('/give/list', methods=['GET'])
def give_list():
    """
    点赞列表
    """
    form = GiveCommentListFrom(request.args).validate_()
    data = list_give(form.fcmid.data, form.uid.data)
    return result_format(code=200, data=data, message="操作成功")


@api.route('/circle/info', methods=['GET'])
def circle_info_list():
    """
    获取用户朋友圈（详情）
    """
    page = request.args.get('page', default=1, type=int)
    limit = request.args.get('size', default=10, type=int)
    form = CircleListFrom(request.args).validate_()
    query_user = FriendMessage.query.filter(*form.params).order_by(FriendMessage.id.desc())
    paginate = query_user.paginate(page=page, per_page=limit, error_out=True)
    data = [item.serialization(increase={'create_time', 'uid', 'status'}) for item in paginate.items]
    datas = get_infoname(data)
    items = paginate_info(paginate=paginate)
    return result_format(code=200, data=datas, **items, message="查询成功")


@api.route('/content/delete', methods=['GET'])
def friends_delete():
    """
    删除朋友圈信息
    """
    ContentListFrom(request.args).validate_()
    return result_format(code=200, message='删除成功')
