<?php

use support\Db;

require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/support/bootstrap.php';


$startId    = 2451541;
$endId      = 2452324;
$connection = 'fj-clearing';
for (
    $i = $startId;
    $i <= $endId;
    $i++
) {
    $assets = Db::connection($connection)->table('user_assets')->where('id', $i)->get();
    $assets = $assets->isNotEmpty() ? $assets->toArray() : [];
    if (count($assets) > 1) {
        try {
            $assets = [
                'id'          => $assets[0]->id,
                'uuid'        => $assets[0]->uuid,
                'type'        => $assets[0]->type,
                'unique_tag'  => $assets[0]->unique_tag,
                'beneficiary' => $assets[0]->beneficiary,
                'status'      => $assets[0]->status,
                'create_time' => $assets[0]->create_time,
                'update_time' => $assets[0]->update_time,
            ];

            /** 删除原数据 */
            Db::connection($connection)->table('user_assets')
                ->where(['id' => $assets['id'], 'uuid' => $assets['uuid']])
                ->delete();
            /** 重新插入这条数据到 user_assets 表*/
            $id = Db::connection($connection)->table('user_assets')->insertGetId([
                'uuid'        => $assets['uuid'],
                'type'        => $assets['type'],
                'unique_tag'  => $assets['unique_tag'],
                'beneficiary' => $assets['beneficiary'],
                'status'      => $assets['status'],
                'create_time' => $assets['create_time'],
                'update_time' => $assets['update_time'],
            ]);
            Db::connection($connection)->beginTransaction();
            # 处理背包
            /** @var  $backpack * 根据id和UUID去查 */
            $backpack = Db::connection($connection)->table('user_assets_backpack')
                ->where(['id' => $assets['id'], 'uuid' => $assets['uuid']])
                ->first();
            if ($backpack) {
                $backpack = [
                    'uuid'           => $backpack->uuid,
                    'last_amount'    => $backpack->last_amount,
                    'current_amount' => $backpack->current_amount,
                    'status'         => $backpack->status,
                    'create_time'    => $backpack->create_time,
                    'update_time'    => $backpack->update_time,
                ] + ['id' => $id];
                /** 删除原数据 */
                Db::connection($connection)
                    ->table('user_assets_backpack')
                    ->where(['id' => $assets['id'], 'uuid' => $assets['uuid']])
                    ->delete();

                /** 重新插入这条数据到 user_assets_backpack 表*/
                Db::connection($connection)->table('user_assets_backpack')->insert($backpack);

            }


            # 处理消费账户
            /** @var  $consumable * 根据id和UUID去查 */
            $consumable = Db::connection($connection)->table('user_assets_consumable')
                ->where(['id' => $assets['id'], 'uuid' => $assets['uuid']])
                ->first();
            if ($consumable) {
                $consumable = [
                    'uuid'           => $consumable->uuid,
                    'last_amount'    => $consumable->last_amount,
                    'current_amount' => $consumable->current_amount,
                    'status'         => $consumable->status,
                    'create_time'    => $consumable->create_time,
                    'update_time'    => $consumable->update_time,
                ] + ['id' => $id];

                /** 删除原数据 */
                Db::connection($connection)
                    ->table('user_assets_consumable')
                    ->where(['id' => $assets['id'], 'uuid' => $assets['uuid']])
                    ->delete();
                /** 重新插入这条数据到 user_assets_consumable 表*/
                Db::connection($connection)->table('user_assets_consumable')->insert($consumable);

            }


            # 处理消费账户
            /** @var  $withdrawable * 根据id和UUID去查 */
            $withdrawable = Db::connection($connection)->table('user_assets_withdrawable')
                ->where(['id' => $assets['id'], 'uuid' => $assets['uuid']])
                ->first();
            if ($withdrawable) {
                $withdrawable = [
                    'uuid'           => $withdrawable->uuid,
                    'last_amount'    => $withdrawable->last_amount,
                    'current_amount' => $withdrawable->current_amount,
                    'status'         => $withdrawable->status,
                    'create_time'    => $withdrawable->create_time,
                    'update_time'    => $withdrawable->update_time,
                ] + ['id' => $id];
                /** 删除原数据 */
                Db::connection($connection)
                    ->table('user_assets_withdrawable')
                    ->where(['id' => $assets['id'], 'uuid' => $assets['uuid']])
                    ->delete();
                /** 重新插入这条数据到 user_assets_withdrawable 表*/
                Db::connection($connection)->table('user_assets_withdrawable')->insert($withdrawable);

            }
            Db::connection($connection)->commit();
            var_dump('已处理id:' . $i);
        } catch (Throwable $e) {
            Db::connection($connection)->rollBack();
            var_dump($e);
            echo "\033[31;1m" . "错误id:" . $i . "\n";
        }

    }
}